/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.filter;

import cn.org.gddsn.signal.filter.Complex;
import cn.org.gddsn.signal.filter.DirectFilter;
import cn.org.gddsn.signal.filter.FIRFilterType;
import cn.org.gddsn.signal.filter.Filter;

class SincBandStopFilter
extends FIRFilterType {
    int n;
    double wc1;
    double wc2;
    double mult;
    double peak;
    double[] resp;
    boolean invert;

    SincBandStopFilter() {
    }

    int select() {
        this.auxLabels[0] = "Center Frequency";
        this.auxLabels[1] = this.invert ? "Passband Width" : "Stopband Width";
        this.auxLabels[2] = "Order";
        this.auxBars[0] = 500;
        this.auxBars[1] = 50;
        this.auxBars[2] = 140;
        return 3;
    }

    void setup() {
        double wcmid = (double)this.auxBars[0] * Math.PI / 1000.0;
        double width = (double)this.auxBars[1] * Math.PI / 1000.0;
        this.wc1 = wcmid - width;
        this.wc2 = wcmid + width;
        if (this.wc1 < 0.0) {
            this.wc1 = 0.0;
        }
        if (this.wc2 > Math.PI) {
            this.wc2 = Math.PI;
        }
        this.n = this.auxBars[2];
    }

    int getPoleCount() {
        return 0;
    }

    void getPole(int i, Complex c1) {
    }

    Filter genFilter() {
        int ii;
        DirectFilter f = new DirectFilter();
        f.aList = new double[this.n + 1];
        double[] xlist = new double[this.n + 1];
        int n2 = this.n / 2;
        double sum = 0.0;
        int i = 0;
        while (i != this.n) {
            ii = i - n2;
            f.aList[i] = (ii == 0 ? this.wc1 : Math.sin(this.wc1 * (double)ii) / (double)ii) * this.getWindow(i, this.n);
            sum += f.aList[i];
            ++i;
        }
        if (sum > 0.0) {
            i = 0;
            while (i != this.n) {
                int n = i++;
                f.aList[n] = f.aList[n] / sum;
            }
        }
        sum = 0.0;
        i = 0;
        while (i != this.n) {
            ii = i - n2;
            xlist[i] = (ii == 0 ? this.wc2 : Math.sin(this.wc2 * (double)ii) / (double)ii) * this.getWindow(i, this.n);
            sum += xlist[i];
            ++i;
        }
        i = 0;
        while (i != this.n) {
            int n = i++;
            xlist[n] = xlist[n] / sum;
        }
        i = 0;
        while (i != this.n) {
            int n = i;
            f.aList[n] = f.aList[n] - xlist[i];
            ++i;
        }
        int n = n2;
        f.aList[n] = f.aList[n] + 1.0;
        if (this.invert) {
            i = 0;
            while (i != this.n) {
                f.aList[i] = -f.aList[i];
                ++i;
            }
            int n3 = n2;
            f.aList[n3] = f.aList[n3] + 1.0;
        }
        if (this.n == 1) {
            f.aList[0] = 1.0;
        }
        this.setResponse(f);
        return f;
    }

    void getInfo(String[] x) {
        x[0] = this.invert ? "Passband: " : "Stopband: ";
        x[0] = String.valueOf(x[0]) + this.getOmegaText(this.wc1) + " - " + this.getOmegaText(this.wc2);
        x[1] = "Order: " + this.n;
    }

    boolean needsWindow() {
        return true;
    }
}

