/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.filter.design;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;

class GraphPlot
extends Canvas {
    private static final long serialVersionUID = 1L;
    public static final int SIGNAL = 1;
    public static final int SPECTRUM = 2;
    Color plotColor = Color.yellow;
    Color axisColor = Color.black;
    Color gridColor = Color.black;
    Color bgColor = Color.blue;
    int plotStyle = 1;
    boolean tracePlot = true;
    boolean logScale = false;
    int vertSpace = 20;
    int horzSpace = 20;
    int vertIntervals = 8;
    int horzIntervals = 10;
    int nPoints = 0;
    double xmax = 0.0;
    double ymax = 0.0;
    double xScale;
    double yScale;
    private double[] plotValues;

    public void setPlotColor(Color c) {
        if (c != null) {
            this.plotColor = c;
        }
    }

    public Color getPlotColor() {
        return this.plotColor;
    }

    public void setAxisColor(Color c) {
        if (c != null) {
            this.axisColor = c;
        }
    }

    public Color getAxisColor() {
        return this.axisColor;
    }

    public void setGridColor(Color c) {
        if (c != null) {
            this.gridColor = c;
        }
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setBgColor(Color c) {
        if (c != null) {
            this.bgColor = c;
        }
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    public void setPlotStyle(int pst) {
        this.plotStyle = pst;
    }

    public int getPlotStyle() {
        return this.plotStyle;
    }

    public void setTracePlot(boolean b) {
        this.tracePlot = b;
    }

    public boolean isTracePlot() {
        return this.tracePlot;
    }

    public void setLogScale(boolean b) {
        this.logScale = b;
    }

    public boolean isLogScale() {
        return this.logScale;
    }

    public void setVertSpace(int v) {
        this.vertSpace = v;
    }

    public int getVertSpace() {
        return this.vertSpace;
    }

    public void setHorzSpace(int h) {
        this.horzSpace = h;
    }

    public int getHorzSpace() {
        return this.horzSpace;
    }

    public int getVertIntervals() {
        return this.vertIntervals;
    }

    public void setVertIntervals(int i) {
        this.vertIntervals = i;
    }

    public int getHorzIntervals() {
        return this.horzIntervals;
    }

    public void setHorzIntervals(int i) {
        this.horzIntervals = i;
    }

    public void setYmax(double m) {
        this.ymax = m;
    }

    public double getYmax() {
        return this.ymax;
    }

    public void setPlotValues(double[] values) {
        this.nPoints = values.length;
        this.plotValues = new double[this.nPoints];
        this.plotValues = values;
        this.repaint();
    }

    public void paint(Graphics g) {
        int centre;
        int top = this.vertSpace;
        int bottom = this.getSize().height - this.vertSpace;
        int left = this.horzSpace;
        int right = this.getSize().width - this.horzSpace;
        int width = right - left;
        int fullHeight = bottom - top;
        int xAxisPos = centre = (top + bottom) / 2;
        int yHeight = fullHeight / 2;
        if (this.plotStyle == 2) {
            xAxisPos = bottom;
            yHeight = fullHeight;
        }
        this.setBackground(this.bgColor);
        if (this.logScale) {
            xAxisPos = top;
            g.setColor(this.gridColor);
            int i = 0;
            while (i <= this.vertIntervals) {
                int x = left + i * width / this.vertIntervals;
                g.drawLine(x, top, x, bottom);
                ++i;
            }
            i = 0;
            while (i <= this.horzIntervals) {
                int y = top + i * fullHeight / this.horzIntervals;
                g.drawLine(left, y, right, y);
                ++i;
            }
        }
        g.setColor(this.axisColor);
        g.drawLine(left, top, left, bottom);
        g.drawLine(left, xAxisPos, right, xAxisPos);
        if (this.nPoints != 0) {
            g.setColor(this.plotColor);
            this.xScale = (double)width / (double)(this.nPoints - 1);
            this.yScale = (double)yHeight / this.ymax;
            int[] xCoords = new int[this.nPoints];
            int[] yCoords = new int[this.nPoints];
            int i = 0;
            while (i < this.nPoints) {
                xCoords[i] = left + (int)Math.round((double)i * this.xScale);
                yCoords[i] = xAxisPos - (int)Math.round(this.plotValues[i] * this.yScale);
                ++i;
            }
            if (this.tracePlot) {
                g.drawPolyline(xCoords, yCoords, this.nPoints);
            } else {
                i = 0;
                while (i < this.nPoints) {
                    g.drawLine(xCoords[i], xAxisPos, xCoords[i], yCoords[i]);
                    ++i;
                }
            }
        }
    }
}

