/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.filter.design;

public class IIRFilter {
    public static final int LP = 1;
    public static final int HP = 2;
    public static final int BP = 3;
    public static final int BUTTERWORTH = 4;
    public static final int CHEBYSHEV = 5;
    private int order = 1;
    private int prototype = 4;
    private int filterType = 1;
    private int freqPoints;
    private double fp1 = 0.0;
    private double fp2 = 10.0;
    private double fN = 0.5 * this.rate;
    private double ripple = 1.0;
    private double rate = 100.0;
    private double[] pReal;
    private double[] pImag;
    private double[] z;
    private double[] aCoeff;
    private double[] bCoeff;

    public void setPrototype(String p) {
        if (p.equals("Butterworth")) {
            this.setPrototype(4);
        }
        if (p.equals("Chebyshev")) {
            this.setPrototype(5);
        }
    }

    public void setPrototype(int p) {
        this.prototype = p;
    }

    public int getPrototype() {
        return this.prototype;
    }

    public void setFilterType(String ft) {
        if (ft.equals("LP")) {
            this.setFilterType(1);
        }
        if (ft.equals("BP")) {
            this.setFilterType(3);
        }
        if (ft.equals("HP")) {
            this.setFilterType(2);
        }
    }

    public int getFilterType() {
        return this.filterType;
    }

    public void setFilterType(int ft) {
        this.filterType = ft;
        if (this.filterType == 3 && this.odd(this.order)) {
            ++this.order;
        }
    }

    public void setOrder(int n) {
        this.order = Math.abs(n);
        if (this.filterType == 3 && this.odd(this.order)) {
            ++this.order;
        }
    }

    public int getOrder() {
        return this.order;
    }

    public void setRate(double r) {
        this.rate = r;
        this.fN = 0.5 * this.rate;
    }

    public double getRate() {
        return this.rate;
    }

    public void setFreq1(double fp1) {
        this.fp1 = fp1;
    }

    public double getFreq1() {
        return this.fp1;
    }

    public void setFreq2(double fp2) {
        this.fp2 = fp2;
    }

    public double getFreq2() {
        return this.fp2;
    }

    public void setRipple(double r) {
        this.ripple = r;
    }

    public double getRipple() {
        return this.ripple;
    }

    public void setFreqPoints(int f) {
        this.freqPoints = f;
    }

    public int getFreqPoints() {
        return this.freqPoints;
    }

    public double getPReal(int i) {
        return this.pReal[i];
    }

    public double getPImag(int i) {
        return this.pImag[i];
    }

    public double getZero(int i) {
        return this.z[i];
    }

    public double[] getNumCoeff() {
        return this.aCoeff;
    }

    public double[] getDenCoeff() {
        return this.bCoeff;
    }

    double getACoeff(int i) {
        return this.aCoeff[i];
    }

    double getBCoeff(int i) {
        return this.bCoeff[i];
    }

    private double sqr(double x) {
        return x * x;
    }

    boolean odd(int n) {
        return n % 2 != 0;
    }

    private void locatePolesAndZeros() {
        double f1;
        this.pReal = new double[this.order + 1];
        this.pImag = new double[this.order + 1];
        this.z = new double[this.order + 1];
        double ln10 = Math.log(10.0);
        int k = 1;
        while (k <= this.order) {
            this.pReal[k] = 0.0;
            this.pImag[k] = 0.0;
            ++k;
        }
        int n = this.order;
        if (this.filterType == 3) {
            n /= 2;
        }
        int ir = n % 2;
        int n1 = n + ir;
        int n2 = (3 * n + ir) / 2 - 1;
        switch (this.filterType) {
            case 1: {
                f1 = this.fp2;
                break;
            }
            case 2: {
                f1 = this.fN - this.fp1;
                break;
            }
            case 3: {
                f1 = this.fp2 - this.fp1;
                break;
            }
            default: {
                f1 = 0.0;
            }
        }
        double tanw1 = Math.tan(1.5707963267948966 * f1 / this.fN);
        double tansqw1 = this.sqr(tanw1);
        double a = 1.0;
        double r = 1.0;
        double i = 1.0;
        int k2 = n1;
        while (k2 <= n2) {
            double t = 0.5 * (double)(2 * k2 + 1 - ir) * Math.PI / (double)n;
            switch (this.prototype) {
                case 4: {
                    double b3 = 1.0 - 2.0 * tanw1 * Math.cos(t) + tansqw1;
                    r = (1.0 - tansqw1) / b3;
                    i = 2.0 * tanw1 * Math.sin(t) / b3;
                    break;
                }
                case 5: {
                    double d = 1.0 - Math.exp(-0.05 * this.ripple * ln10);
                    double e = 1.0 / Math.sqrt(1.0 / this.sqr(1.0 - d) - 1.0);
                    double x = Math.pow(Math.sqrt(e * e + 1.0) + e, 1.0 / (double)n);
                    a = 0.5 * (x - 1.0 / x);
                    double b = 0.5 * (x + 1.0 / x);
                    double c3 = a * tanw1 * Math.cos(t);
                    double c4 = b * tanw1 * Math.sin(t);
                    double c5 = this.sqr(1.0 - c3) + this.sqr(c4);
                    r = 2.0 * (1.0 - c3) / c5 - 1.0;
                    i = 2.0 * c4 / c5;
                }
            }
            int m = 2 * (n2 - k2) + 1;
            this.pReal[m + ir] = r;
            this.pImag[m + ir] = Math.abs(i);
            this.pReal[m + ir + 1] = r;
            this.pImag[m + ir + 1] = -Math.abs(i);
            ++k2;
        }
        if (this.odd(n)) {
            if (this.prototype == 4) {
                r = (1.0 - tansqw1) / (1.0 + 2.0 * tanw1 + tansqw1);
            }
            if (this.prototype == 5) {
                r = 2.0 / (1.0 + a * tanw1) - 1.0;
            }
            this.pReal[1] = r;
            this.pImag[1] = 0.0;
        }
        switch (this.filterType) {
            case 1: {
                int m2 = 1;
                while (m2 <= n) {
                    this.z[m2] = -1.0;
                    ++m2;
                }
                break;
            }
            case 2: {
                int m2 = 1;
                while (m2 <= n) {
                    this.pReal[m2] = -this.pReal[m2];
                    this.z[m2] = 1.0;
                    ++m2;
                }
                break;
            }
            case 3: {
                int m;
                int m2 = 1;
                while (m2 <= n) {
                    this.z[m2] = 1.0;
                    this.z[m2 + n] = -1.0;
                    ++m2;
                }
                double f4 = 1.5707963267948966 * this.fp1 / this.fN;
                double f5 = 1.5707963267948966 * this.fp2 / this.fN;
                double aa = Math.cos(f4 + f5) / Math.cos(f5 - f4);
                int m1 = 0;
                while (m1 <= (this.order - 1) / 2) {
                    double p2I;
                    double p1I;
                    double p2R;
                    double p1R;
                    m = 1 + 2 * m1;
                    double aR = this.pReal[m];
                    double aI = this.pImag[m];
                    if (Math.abs(aI) < 1.0E-4) {
                        double h1 = 0.5 * aa * (1.0 + aR);
                        double h2 = this.sqr(h1) - aR;
                        if (h2 > 0.0) {
                            p1R = h1 + Math.sqrt(h2);
                            p2R = h1 - Math.sqrt(h2);
                            p1I = 0.0;
                            p2I = 0.0;
                        } else {
                            p1R = h1;
                            p2R = h1;
                            p1I = Math.sqrt(Math.abs(h2));
                            p2I = -p1I;
                        }
                    } else {
                        double fR = aa * 0.5 * (1.0 + aR);
                        double fI = aa * 0.5 * aI;
                        double gR = this.sqr(fR) - this.sqr(fI) - aR;
                        double gI = 2.0 * fR * fI - aI;
                        double sR = Math.sqrt(0.5 * Math.abs(gR + Math.sqrt(this.sqr(gR) + this.sqr(gI))));
                        double sI = gI / (2.0 * sR);
                        p1R = fR + sR;
                        p1I = fI + sI;
                        p2R = fR - sR;
                        p2I = fI - sI;
                    }
                    this.pReal[m] = p1R;
                    this.pReal[m + 1] = p2R;
                    this.pImag[m] = p1I;
                    this.pImag[m + 1] = p2I;
                    ++m1;
                }
                if (this.odd(n)) {
                    this.pReal[2] = this.pReal[n + 1];
                    this.pImag[2] = this.pImag[n + 1];
                }
                int k3 = n;
                while (k3 >= 1) {
                    m = 2 * k3 - 1;
                    this.pReal[m] = this.pReal[k3];
                    this.pReal[m + 1] = this.pReal[k3];
                    this.pImag[m] = Math.abs(this.pImag[k3]);
                    this.pImag[m + 1] = -Math.abs(this.pImag[k3]);
                    --k3;
                }
                break;
            }
        }
    }

    public void design() {
        this.aCoeff = new double[this.order + 1];
        this.bCoeff = new double[this.order + 1];
        double[] newA = new double[this.order + 1];
        double[] newB = new double[this.order + 1];
        this.locatePolesAndZeros();
        this.aCoeff[0] = 1.0;
        this.bCoeff[0] = 1.0;
        int i = 1;
        while (i <= this.order) {
            this.aCoeff[i] = 0.0;
            this.bCoeff[i] = 0.0;
            ++i;
        }
        int k = 0;
        int n = this.order;
        int pairs = n / 2;
        if (this.odd(this.order)) {
            this.aCoeff[1] = -this.z[1];
            this.bCoeff[1] = -this.pReal[1];
            k = 1;
        }
        int p = 1;
        while (p <= pairs) {
            int m = 2 * p - 1 + k;
            double alpha1 = -(this.z[m] + this.z[m + 1]);
            double alpha2 = this.z[m] * this.z[m + 1];
            double beta1 = -2.0 * this.pReal[m];
            double beta2 = this.sqr(this.pReal[m]) + this.sqr(this.pImag[m]);
            newA[1] = this.aCoeff[1] + alpha1 * this.aCoeff[0];
            newB[1] = this.bCoeff[1] + beta1 * this.bCoeff[0];
            int i2 = 2;
            while (i2 <= n) {
                newA[i2] = this.aCoeff[i2] + alpha1 * this.aCoeff[i2 - 1] + alpha2 * this.aCoeff[i2 - 2];
                newB[i2] = this.bCoeff[i2] + beta1 * this.bCoeff[i2 - 1] + beta2 * this.bCoeff[i2 - 2];
                ++i2;
            }
            i2 = 1;
            while (i2 <= n) {
                this.aCoeff[i2] = newA[i2];
                this.bCoeff[i2] = newB[i2];
                ++i2;
            }
            ++p;
        }
    }

    public double[] filterGain() {
        double[] g = new double[this.freqPoints + 1];
        double gMax = -100.0;
        double sc = 10.0 / Math.log(10.0);
        double t = Math.PI / (double)this.freqPoints;
        int i = 0;
        while (i <= this.freqPoints) {
            double theta = (double)i * t;
            if (i == 0) {
                theta = 3.141592653589793E-4;
            }
            if (i == this.freqPoints) {
                theta = 3.141278494324434;
            }
            double sac = 0.0;
            double sas = 0.0;
            double sbc = 0.0;
            double sbs = 0.0;
            int k = 0;
            while (k <= this.order) {
                double c = Math.cos((double)k * theta);
                double s = Math.sin((double)k * theta);
                sac += c * this.aCoeff[k];
                sas += s * this.aCoeff[k];
                sbc += c * this.bCoeff[k];
                sbs += s * this.bCoeff[k];
                ++k;
            }
            g[i] = sc * Math.log((this.sqr(sac) + this.sqr(sas)) / (this.sqr(sbc) + this.sqr(sbs)));
            gMax = Math.max(gMax, g[i]);
            ++i;
        }
        i = 0;
        while (i <= this.freqPoints) {
            int n = i++;
            g[n] = g[n] - gMax;
        }
        double normFactor = Math.pow(10.0, -0.05 * gMax);
        int i2 = 0;
        while (i2 <= this.order) {
            int n = i2++;
            this.aCoeff[n] = this.aCoeff[n] * normFactor;
        }
        return g;
    }

    public static void main(String[] args) {
        IIRFilter iirFilter = new IIRFilter();
        iirFilter.setFilterType(2);
        iirFilter.setOrder(2);
        iirFilter.setFreq1(0.075);
        iirFilter.setFreq2(50.0);
        iirFilter.setFreqPoints(250);
        iirFilter.setRate(100.0);
        iirFilter.design();
        iirFilter.filterGain();
        double[] num = iirFilter.getNumCoeff();
        System.out.print("B=");
        int i = 0;
        while (i < num.length) {
            System.out.printf("%.9f ", num[i]);
            ++i;
        }
        System.out.println();
        System.out.print("A=");
        double[] den = iirFilter.getDenCoeff();
        int i2 = 0;
        while (i2 < den.length) {
            System.out.printf("%.9f ", den[i2]);
            ++i2;
        }
        System.out.println();
    }
}

