/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.filter.design;

import cn.org.gddsn.signal.filter.design.GraphPlot;
import cn.org.gddsn.signal.filter.design.IIRFilter;
import cn.org.gddsn.signal.filter.design.IIRFilterDesign_btnCoeffs_actionAdapter;
import cn.org.gddsn.signal.filter.design.IIRFilterDesign_btnDesign_actionAdapter;
import cn.org.gddsn.signal.filter.design.IIRFilterDesign_btnPoleZero_actionAdapter;
import cn.org.gddsn.signal.filter.design.IIRFilterDesign_btnResponse_actionAdapter;
import cn.org.gddsn.signal.filter.design.IIRFilterDesign_cbBandPass_itemAdapter;
import cn.org.gddsn.signal.filter.design.IIRFilterDesign_cbButterworth_itemAdapter;
import cn.org.gddsn.signal.filter.design.IIRFilterDesign_cbChebyshev_itemAdapter;
import cn.org.gddsn.signal.filter.design.IIRFilterDesign_cbHighPass_itemAdapter;
import cn.org.gddsn.signal.filter.design.IIRFilterDesign_cbLowPass_itemAdapter;
import cn.org.gddsn.signal.filter.design.IIRFilterDesign_chMinGain_itemAdapter;
import cn.org.gddsn.signal.filter.design.IIRFilterDesign_tfFreq1_textAdapter;
import cn.org.gddsn.signal.filter.design.IIRFilterDesign_tfFreq2_textAdapter;
import cn.org.gddsn.signal.filter.design.IIRFilterDesign_tfOrder_textAdapter;
import cn.org.gddsn.signal.filter.design.IIRFilterDesign_tfRipple_textAdapter;
import cn.org.gddsn.signal.filter.design.PoleZeroPlot;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.TextEvent;

public class IIRFilterDesign
extends Applet {
    private static final long serialVersionUID = 1L;
    double rate = 50.0;
    int freqPoints = 250;
    int maxOrder = 16;
    int order;
    String filterType;
    String prototype;
    double[] gain = new double[this.freqPoints + 1];
    IIRFilter filter = new IIRFilter();
    GraphPlot frPlot = new GraphPlot();
    PoleZeroPlot pzPlot = new PoleZeroPlot();
    boolean isStandalone = false;
    BorderLayout borderLayout1 = new BorderLayout();
    Panel pnlControls = new Panel();
    GridLayout gridLayout1 = new GridLayout();
    Panel pnlLeftPanel = new Panel();
    GridLayout gridLayout2 = new GridLayout();
    Panel pnlRightPanel = new Panel();
    GridLayout gridLayout3 = new GridLayout();
    Panel pnlFilterType = new Panel();
    FlowLayout flowLayout1 = new FlowLayout();
    Label lblFilterType = new Label();
    CheckboxGroup cbgFilterType = new CheckboxGroup();
    Checkbox cbLowPass = new Checkbox();
    Checkbox cbBandPass = new Checkbox();
    Checkbox cbHighPass = new Checkbox();
    Panel pnlPrototype = new Panel();
    FlowLayout flowLayout2 = new FlowLayout();
    Label lblPrototype = new Label();
    CheckboxGroup cbgPrototype = new CheckboxGroup();
    Checkbox cbButterworth = new Checkbox();
    Checkbox cbChebyshev = new Checkbox();
    Panel pnlOrder = new Panel();
    FlowLayout flowLayout3 = new FlowLayout();
    Label lblOrder = new Label();
    TextField tfOrder = new TextField();
    Panel pnlPassband = new Panel();
    FlowLayout flowLayout4 = new FlowLayout();
    Label lblPassband = new Label();
    TextField tfFreq1 = new TextField();
    Label lblTo = new Label();
    TextField tfFreq2 = new TextField();
    Label lblHz = new Label();
    Panel pnlRipple = new Panel();
    FlowLayout flowLayout5 = new FlowLayout();
    Label lblRipple = new Label();
    TextField tfRipple = new TextField();
    Label lblRippleUnit = new Label();
    Panel pnlButtons1 = new Panel();
    Panel pnlMinGain = new Panel();
    FlowLayout flowLayout6 = new FlowLayout();
    FlowLayout flowLayout7 = new FlowLayout();
    Button btnResponse = new Button();
    Button btnDesign = new Button();
    Label lblMinGain = new Label();
    Choice chMinGain = new Choice();
    Label lblMinGainUnit = new Label();
    Button btnPoleZero = new Button();
    Label lblMaxOrder = new Label();
    Panel pnlDisplay = new Panel();
    CardLayout cardLayout1 = new CardLayout();
    Panel pnlPZPlot = new Panel();
    Panel pnlFRPlot = new Panel();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    Panel pnlButtons2 = new Panel();
    FlowLayout flowLayout8 = new FlowLayout();
    Panel pnlCoeffs = new Panel();
    BorderLayout borderLayout4 = new BorderLayout();
    TextArea txtCoeffs = new TextArea();
    Button btnCoeffs = new Button();

    public String getParameter(String key, String def) {
        return this.isStandalone ? System.getProperty(key, def) : (this.getParameter(key) != null ? this.getParameter(key) : def);
    }

    public void init() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void jbInit() throws Exception {
        Font f = new Font("Dialog", 0, 11);
        this.setSize(new Dimension(600, 400));
        this.gridLayout1.setColumns(2);
        this.gridLayout2.setColumns(1);
        this.gridLayout3.setRows(4);
        this.gridLayout3.setColumns(1);
        this.flowLayout1.setAlignment(0);
        this.lblFilterType.setFont(f);
        this.lblFilterType.setText("Filter type:");
        this.cbLowPass.setFont(f);
        this.cbLowPass.setLabel("LP");
        this.cbLowPass.setCheckboxGroup(this.cbgFilterType);
        this.cbLowPass.addItemListener(new IIRFilterDesign_cbLowPass_itemAdapter(this));
        this.cbBandPass.setFont(f);
        this.cbBandPass.setLabel("BP");
        this.cbBandPass.setCheckboxGroup(this.cbgFilterType);
        this.cbBandPass.addItemListener(new IIRFilterDesign_cbBandPass_itemAdapter(this));
        this.cbHighPass.setFont(f);
        this.cbHighPass.setLabel("HP");
        this.cbHighPass.setCheckboxGroup(this.cbgFilterType);
        this.cbHighPass.addItemListener(new IIRFilterDesign_cbHighPass_itemAdapter(this));
        this.cbLowPass.setState(true);
        this.flowLayout2.setAlignment(0);
        this.lblPrototype.setFont(f);
        this.lblPrototype.setText("Prototype:");
        this.cbButterworth.setFont(f);
        this.cbButterworth.setLabel("Butterworth");
        this.cbButterworth.setCheckboxGroup(this.cbgPrototype);
        this.cbButterworth.addItemListener(new IIRFilterDesign_cbButterworth_itemAdapter(this));
        this.cbChebyshev.setFont(f);
        this.cbChebyshev.setLabel("Chebyshev");
        this.cbChebyshev.setCheckboxGroup(this.cbgPrototype);
        this.cbChebyshev.addItemListener(new IIRFilterDesign_cbChebyshev_itemAdapter(this));
        this.cbButterworth.setState(true);
        this.flowLayout3.setAlignment(0);
        this.lblOrder.setFont(f);
        this.lblOrder.setText("Filter order:");
        this.tfOrder.setFont(f);
        this.tfOrder.setText("1");
        this.tfOrder.setColumns(3);
        this.tfOrder.addTextListener(new IIRFilterDesign_tfOrder_textAdapter(this));
        this.lblMaxOrder.setFont(new Font("Dialog", 2, 11));
        this.lblMaxOrder.setText("(max " + String.valueOf(this.maxOrder) + ")");
        this.flowLayout8.setAlignment(0);
        this.txtCoeffs.setText("Filter Coefficients\n\n");
        this.btnCoeffs.addActionListener(new IIRFilterDesign_btnCoeffs_actionAdapter(this));
        this.btnCoeffs.setEnabled(false);
        this.btnCoeffs.setLabel("Coefficients");
        this.pnlCoeffs.setLayout(this.borderLayout4);
        this.pnlButtons2.setLayout(this.flowLayout8);
        this.pnlFRPlot.setLayout(this.borderLayout3);
        this.frPlot.setPlotStyle(2);
        this.frPlot.setTracePlot(true);
        this.frPlot.setLogScale(true);
        this.pzPlot.setSize(new Dimension(300, 268));
        this.frPlot.setBgColor(Color.lightGray);
        this.frPlot.setPlotColor(Color.blue);
        this.frPlot.setAxisColor(Color.darkGray);
        this.frPlot.setGridColor(Color.darkGray);
        this.pnlFRPlot.add((Component)this.frPlot, "Center");
        this.pnlCoeffs.add((Component)this.txtCoeffs, "Center");
        this.pnlPZPlot.setLayout(this.borderLayout2);
        this.pnlPZPlot.add((Component)this.pzPlot, "Center");
        this.pnlDisplay.setLayout(this.cardLayout1);
        this.pnlDisplay.add((Component)this.pnlPZPlot, "PZPlot");
        this.pnlDisplay.add((Component)this.pnlFRPlot, "FRPlot");
        this.pnlDisplay.add((Component)this.pnlCoeffs, "Coeffs");
        this.flowLayout4.setAlignment(0);
        this.lblPassband.setFont(f);
        this.lblPassband.setText("Passband:");
        this.tfFreq1.setFont(f);
        this.tfFreq1.setText("0");
        this.tfFreq1.setColumns(5);
        this.tfFreq1.addTextListener(new IIRFilterDesign_tfFreq1_textAdapter(this));
        this.lblTo.setFont(f);
        this.lblTo.setAlignment(1);
        this.lblTo.setText("to");
        this.tfFreq2.setFont(f);
        this.tfFreq2.setText("1000");
        this.tfFreq2.setColumns(5);
        this.tfFreq2.addTextListener(new IIRFilterDesign_tfFreq2_textAdapter(this));
        this.lblHz.setFont(f);
        this.lblHz.setText("Hz");
        this.flowLayout5.setAlignment(0);
        this.lblRipple.setEnabled(false);
        this.lblRipple.setFont(f);
        this.lblRipple.setText("Passband ripple:");
        this.tfRipple.setEnabled(false);
        this.tfRipple.setFont(f);
        this.tfRipple.setText("1.0");
        this.tfRipple.setColumns(3);
        this.tfRipple.addTextListener(new IIRFilterDesign_tfRipple_textAdapter(this));
        this.lblRippleUnit.setEnabled(false);
        this.lblRippleUnit.setFont(f);
        this.lblRippleUnit.setText("dB");
        this.flowLayout6.setAlignment(0);
        this.flowLayout7.setAlignment(0);
        this.btnResponse.setEnabled(false);
        this.btnResponse.setFont(f);
        this.btnResponse.setLabel("Frequency response");
        this.btnResponse.addActionListener(new IIRFilterDesign_btnResponse_actionAdapter(this));
        this.btnDesign.setFont(f);
        this.btnDesign.setLabel("Design");
        this.lblMinGain.setEnabled(false);
        this.lblMinGain.setFont(f);
        this.lblMinGain.setText("Minimum plot gain:");
        this.lblMinGainUnit.setEnabled(false);
        this.lblMinGainUnit.setFont(f);
        this.lblMinGainUnit.setText("dB");
        this.btnPoleZero.setLabel("Poles/Zeros");
        this.btnPoleZero.setEnabled(false);
        this.btnPoleZero.setFont(f);
        this.btnPoleZero.addActionListener(new IIRFilterDesign_btnPoleZero_actionAdapter(this));
        this.chMinGain.addItem("-10");
        this.chMinGain.addItem("-50");
        this.chMinGain.addItem("-100");
        this.chMinGain.addItem("-200");
        this.chMinGain.select("-100");
        this.chMinGain.addItemListener(new IIRFilterDesign_chMinGain_itemAdapter(this));
        this.chMinGain.setEnabled(false);
        this.chMinGain.setFont(f);
        this.btnDesign.addActionListener(new IIRFilterDesign_btnDesign_actionAdapter(this));
        this.pnlButtons1.setLayout(this.flowLayout7);
        this.pnlMinGain.setLayout(this.flowLayout6);
        this.pnlRipple.setLayout(this.flowLayout5);
        this.pnlPassband.setLayout(this.flowLayout4);
        this.pnlOrder.setLayout(this.flowLayout3);
        this.pnlPrototype.setLayout(this.flowLayout2);
        this.pnlFilterType.setLayout(this.flowLayout1);
        this.pnlRightPanel.setLayout(this.gridLayout3);
        this.gridLayout2.setRows(4);
        this.pnlLeftPanel.setLayout(this.gridLayout2);
        this.pnlControls.setLayout(this.gridLayout1);
        this.setLayout(this.borderLayout1);
        this.add((Component)this.pnlDisplay, "Center");
        this.add((Component)this.pnlControls, "South");
        this.pnlControls.add((Component)this.pnlLeftPanel, null);
        this.pnlLeftPanel.add((Component)this.pnlFilterType, null);
        this.pnlFilterType.add((Component)this.lblFilterType, null);
        this.pnlFilterType.add((Component)this.cbLowPass, null);
        this.pnlFilterType.add((Component)this.cbBandPass, null);
        this.pnlFilterType.add((Component)this.cbHighPass, null);
        this.pnlLeftPanel.add((Component)this.pnlPrototype, null);
        this.pnlPrototype.add((Component)this.lblPrototype, null);
        this.pnlPrototype.add((Component)this.cbButterworth, null);
        this.pnlPrototype.add((Component)this.cbChebyshev, null);
        this.pnlLeftPanel.add((Component)this.pnlOrder, null);
        this.pnlOrder.add((Component)this.lblOrder, null);
        this.pnlOrder.add((Component)this.tfOrder, null);
        this.pnlOrder.add((Component)this.lblMaxOrder, null);
        this.pnlLeftPanel.add((Component)this.pnlPassband, null);
        this.pnlPassband.add((Component)this.lblPassband, null);
        this.pnlPassband.add((Component)this.tfFreq1, null);
        this.pnlPassband.add((Component)this.lblTo, null);
        this.pnlPassband.add((Component)this.tfFreq2, null);
        this.pnlPassband.add((Component)this.lblHz, null);
        this.pnlControls.add((Component)this.pnlRightPanel, null);
        this.pnlRightPanel.add((Component)this.pnlRipple, null);
        this.pnlRipple.add((Component)this.lblRipple, null);
        this.pnlRipple.add((Component)this.tfRipple, null);
        this.pnlRipple.add((Component)this.lblRippleUnit, null);
        this.pnlRightPanel.add((Component)this.pnlMinGain, null);
        this.pnlMinGain.add((Component)this.lblMinGain, null);
        this.pnlMinGain.add((Component)this.chMinGain, null);
        this.pnlMinGain.add((Component)this.lblMinGainUnit, null);
        this.pnlRightPanel.add((Component)this.pnlButtons1, null);
        this.pnlButtons1.add((Component)this.btnDesign, null);
        this.pnlButtons1.add((Component)this.btnPoleZero, null);
        this.pnlRightPanel.add((Component)this.pnlButtons2, null);
        this.pnlButtons2.add((Component)this.btnResponse, null);
        this.pnlButtons2.add((Component)this.btnCoeffs, null);
    }

    public String getAppletInfo() {
        return "(C) 1998 Dr Iain A Robin\nIIR filter design code based on a Pascal program\nlisted in 'Digital Signal Processing with Computer Applications'\nby P. Lynn and W. Fuerst (Prentice Hall)";
    }

    public String[][] getParameterInfo() {
        return null;
    }

    private void setRippleState(boolean b) {
        this.lblRipple.setEnabled(b);
        this.tfRipple.setEnabled(b);
        this.lblRippleUnit.setEnabled(b);
    }

    private void setMinGainState(boolean b) {
        this.lblMinGain.setEnabled(b);
        this.chMinGain.setEnabled(b);
        this.lblMinGainUnit.setEnabled(b);
    }

    void cbChebyshev_itemStateChanged(ItemEvent e) {
        this.setRippleState(this.cbChebyshev.getState());
        this.btnResponse.setEnabled(false);
        this.btnPoleZero.setEnabled(false);
        this.btnPoleZero.setEnabled(false);
    }

    void cbButterworth_itemStateChanged(ItemEvent e) {
        this.setRippleState(this.cbChebyshev.getState());
        this.btnResponse.setEnabled(false);
        this.btnPoleZero.setEnabled(false);
        this.btnPoleZero.setEnabled(false);
    }

    void designFilter() {
        this.order = Integer.parseInt(this.tfOrder.getText());
        if (this.order > this.maxOrder) {
            this.showStatus("Filter order too high (max. " + String.valueOf(this.maxOrder) + ")");
        } else {
            this.filterType = this.cbgFilterType.getSelectedCheckbox().getLabel();
            if (this.filterType.equals("BP") && this.order % 2 != 0) {
                this.showStatus("Filter order must be even for BP filter");
            } else {
                this.filter.setFilterType(this.filterType);
                this.prototype = this.cbgPrototype.getSelectedCheckbox().getLabel();
                this.filter.setPrototype(this.prototype);
                this.filter.setRate(this.rate);
                this.filter.setOrder(this.order);
                this.filter.setFreq1(Double.valueOf(this.tfFreq1.getText()));
                this.filter.setFreq2(Double.valueOf(this.tfFreq2.getText()));
                if (this.cbChebyshev.getState()) {
                    this.filter.setRipple(Double.valueOf(this.tfRipple.getText()));
                }
                this.filter.design();
                this.btnResponse.setEnabled(true);
                this.btnPoleZero.setEnabled(true);
            }
        }
    }

    void btnDesign_actionPerformed(ActionEvent e) {
        this.designFilter();
    }

    void plotPolesAndZeros() {
        double[] pReal = new double[this.order + 1];
        double[] pImag = new double[this.order + 1];
        double[] z = new double[this.order + 1];
        int i = 1;
        while (i <= this.order) {
            pReal[i] = this.filter.getPReal(i);
            pImag[i] = this.filter.getPImag(i);
            z[i] = this.filter.getZero(i);
            ++i;
        }
        this.pzPlot.setPolesAndZeros(pReal, pImag, z);
    }

    void btnPoleZero_actionPerformed(ActionEvent e) {
        this.setMinGainState(false);
        this.plotPolesAndZeros();
        this.cardLayout1.show(this.pnlDisplay, "PZPlot");
    }

    void plotResponse() {
        this.filter.setFreqPoints(this.freqPoints);
        this.gain = this.filter.filterGain();
        this.frPlot.setYmax(this.minPlotGain());
        this.frPlot.setPlotValues(this.gain);
    }

    void listCoeffs() {
        this.txtCoeffs.setText(String.valueOf(this.prototype) + " IIR filter\n\n");
        this.txtCoeffs.append("Filter type: " + this.filterType + "\n");
        this.txtCoeffs.append("Passband: " + this.tfFreq1.getText() + " - " + this.tfFreq2.getText() + " Hz\n");
        if (this.cbChebyshev.getState()) {
            this.txtCoeffs.append("Passband ripple: " + this.tfRipple.getText() + " dB\n");
        }
        this.txtCoeffs.append("Order: " + String.valueOf(this.order) + "\n\n");
        this.txtCoeffs.append("Coefficients\n\n");
        int i = 0;
        while (i <= this.order) {
            this.txtCoeffs.append("num[" + String.valueOf(i) + "] = " + String.valueOf(this.filter.getACoeff(i)) + "     \tden[" + String.valueOf(i) + "] = " + String.valueOf(this.filter.getBCoeff(i)) + "\n");
            ++i;
        }
        this.cardLayout1.show(this.pnlDisplay, "Coeffs");
    }

    void btnResponse_actionPerformed(ActionEvent e) {
        this.setMinGainState(true);
        this.plotResponse();
        this.btnCoeffs.setEnabled(true);
        this.cardLayout1.show(this.pnlDisplay, "FRPlot");
    }

    void btnCoeffs_actionPerformed(ActionEvent e) {
        this.listCoeffs();
    }

    void cbLowPass_itemStateChanged(ItemEvent e) {
        if (this.cbLowPass.getState()) {
            this.tfFreq1.setText("0");
            this.tfFreq2.setText("");
            this.tfFreq1.setEditable(false);
            this.tfFreq2.setEditable(true);
            this.btnResponse.setEnabled(false);
            this.btnPoleZero.setEnabled(false);
            this.btnCoeffs.setEnabled(false);
        }
    }

    void cbBandPass_itemStateChanged(ItemEvent e) {
        if (this.cbBandPass.getState()) {
            this.tfFreq1.setText("");
            this.tfFreq2.setText("");
            this.tfFreq1.setEditable(true);
            this.tfFreq2.setEditable(true);
            this.btnResponse.setEnabled(false);
            this.btnPoleZero.setEnabled(false);
            this.btnCoeffs.setEnabled(false);
        }
    }

    void cbHighPass_itemStateChanged(ItemEvent e) {
        if (this.cbHighPass.getState()) {
            this.tfFreq1.setText("");
            this.tfFreq2.setText(String.valueOf(Math.round(this.rate / 2.0)).toString());
            this.tfFreq1.setEditable(true);
            this.tfFreq2.setEditable(false);
            this.btnResponse.setEnabled(false);
            this.btnPoleZero.setEnabled(false);
            this.btnCoeffs.setEnabled(false);
        }
    }

    private double minPlotGain() {
        return Math.abs(Double.valueOf(this.chMinGain.getSelectedItem()));
    }

    void chMinGain_itemStateChanged(ItemEvent e) {
        if (this.btnResponse.isEnabled()) {
            this.plotResponse();
        }
    }

    void tfFreq1_textValueChanged(TextEvent e) {
        this.btnResponse.setEnabled(false);
        this.btnPoleZero.setEnabled(false);
        this.btnCoeffs.setEnabled(false);
    }

    void tfFreq2_textValueChanged(TextEvent e) {
        this.btnPoleZero.setEnabled(false);
        this.btnResponse.setEnabled(false);
        this.btnCoeffs.setEnabled(false);
    }

    void tfOrder_textValueChanged(TextEvent e) {
        this.btnPoleZero.setEnabled(false);
        this.btnResponse.setEnabled(false);
        this.btnCoeffs.setEnabled(false);
    }

    void tfRipple_textValueChanged(TextEvent e) {
        this.btnPoleZero.setEnabled(false);
        this.btnResponse.setEnabled(false);
        this.btnCoeffs.setEnabled(false);
    }
}

