/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.filter.design;

import cn.org.gddsn.signal.filter.design.GraphPlot;
import cn.org.gddsn.signal.filter.design.RemezFIRFilter;
import cn.org.gddsn.signal.filter.design.RemezFIRFilterDesign_btnCoeffs_actionAdapter;
import cn.org.gddsn.signal.filter.design.RemezFIRFilterDesign_btnDesign_actionAdapter;
import cn.org.gddsn.signal.filter.design.RemezFIRFilterDesign_btnEstimate_actionAdapter;
import cn.org.gddsn.signal.filter.design.RemezFIRFilterDesign_btnPlot_actionAdapter;
import cn.org.gddsn.signal.filter.design.RemezFIRFilterDesign_cbBP_itemAdapter;
import cn.org.gddsn.signal.filter.design.RemezFIRFilterDesign_cbBS_itemAdapter;
import cn.org.gddsn.signal.filter.design.RemezFIRFilterDesign_cbHP_itemAdapter;
import cn.org.gddsn.signal.filter.design.RemezFIRFilterDesign_cbLP_itemAdapter;
import cn.org.gddsn.signal.filter.design.RemezFIRFilterDesign_chMinPlotGain_itemAdapter;
import cn.org.gddsn.signal.filter.design.RemezFIRFilterDesign_tfAtten_textAdapter;
import cn.org.gddsn.signal.filter.design.RemezFIRFilterDesign_tfFreq1_textAdapter;
import cn.org.gddsn.signal.filter.design.RemezFIRFilterDesign_tfFreq2_textAdapter;
import cn.org.gddsn.signal.filter.design.RemezFIRFilterDesign_tfOrder_actionAdapter;
import cn.org.gddsn.signal.filter.design.RemezFIRFilterDesign_tfOrder_textAdapter;
import cn.org.gddsn.signal.filter.design.RemezFIRFilterDesign_tfRipple_textAdapter;
import cn.org.gddsn.signal.filter.design.RemezFIRFilterDesign_tfTransitionBandwidth_textAdapter;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.CardLayout;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.TextEvent;

public class RemezFIRFilterDesign
extends Applet {
    private static final long serialVersionUID = 1L;
    boolean isStandalone = false;
    static int freqPoints = 250;
    int order;
    int numBands;
    int numTaps;
    double[] desired;
    double[] bands;
    double[] weights;
    double[] a;
    double trband;
    double atten;
    double ripple;
    double deltaP;
    double deltaS;
    double rippleRatio;
    double[] gain = new double[freqPoints + 1];
    GraphPlot frPlot = new GraphPlot();
    RemezFIRFilter rf = new RemezFIRFilter();
    boolean lp;
    boolean hp;
    boolean bp;
    boolean bs;
    Font font = new Font("Dialog", 0, 11);
    Panel pnlDisplay = new Panel();
    Panel pnlCoeffs = new Panel();
    Panel pnlControls = new Panel();
    BorderLayout borderLayout1 = new BorderLayout();
    GridLayout gridLayout1 = new GridLayout();
    Panel pnlRipple = new Panel();
    FlowLayout flowLayout1 = new FlowLayout();
    Label lblRipple = new Label();
    Panel pnlFrequency = new Panel();
    FlowLayout flowLayout2 = new FlowLayout();
    TextField tfRipple = new TextField();
    Panel pnlOrder = new Panel();
    Panel pnlAtten = new Panel();
    Label lblOrder = new Label();
    TextField tfOrder = new TextField();
    FlowLayout flowLayout3 = new FlowLayout();
    Label lblAtten = new Label();
    TextField tfAtten = new TextField();
    Panel pnlTransitionBandwidth = new Panel();
    FlowLayout flowLayout4 = new FlowLayout();
    Label lblTransitionBandwidth = new Label();
    TextField tfTransitionBandwidth = new TextField();
    FlowLayout flowLayout5 = new FlowLayout();
    Panel pnlButtons = new Panel();
    FlowLayout flowLayout6 = new FlowLayout();
    Button btnDesign = new Button();
    Panel pnlFilterType = new Panel();
    Panel pnlMinPlotGain = new Panel();
    CheckboxGroup cbgFilterType = new CheckboxGroup();
    Checkbox cbBP = new Checkbox();
    Checkbox cbHP = new Checkbox();
    Checkbox cbLP = new Checkbox();
    Checkbox cbBS = new Checkbox();
    Label lblFrequency = new Label();
    TextField tfFreq1 = new TextField();
    Label lblTo = new Label();
    TextField tfFreq2 = new TextField();
    FlowLayout flowLayout7 = new FlowLayout();
    Label lblSpace = new Label();
    Button btnEstimate = new Button();
    Label lblMinPlotGain = new Label();
    FlowLayout flowLayout8 = new FlowLayout();
    Choice chMinPlotGain = new Choice();
    CardLayout cardLayout1 = new CardLayout();
    TextArea txtCoeffs = new TextArea();
    Button btnPlot = new Button();
    Button btnCoeffs = new Button();
    BorderLayout borderLayout2 = new BorderLayout();

    public String getParameter(String key, String def) {
        return this.isStandalone ? System.getProperty(key, def) : (this.getParameter(key) != null ? this.getParameter(key) : def);
    }

    public void init() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.setSize(new Dimension(500, 350));
        this.add((Component)this.pnlDisplay, "Center");
        this.add((Component)this.pnlControls, "South");
        this.txtCoeffs.setText("Filter coefficients\n\n");
        this.pnlDisplay.setLayout(this.cardLayout1);
        this.pnlDisplay.add((Component)this.frPlot, "FRPlot");
        this.pnlDisplay.add((Component)this.pnlCoeffs, "Coeffs");
        this.pnlCoeffs.setLayout(this.borderLayout2);
        this.pnlCoeffs.add((Component)this.txtCoeffs, "Center");
        this.pnlFilterType.setLayout(this.flowLayout7);
        this.pnlFilterType.add((Component)this.cbLP, null);
        this.pnlFilterType.add((Component)this.cbHP, null);
        this.pnlFilterType.add((Component)this.cbBP, null);
        this.pnlFilterType.add((Component)this.cbBS, null);
        this.pnlControls.add((Component)this.pnlFilterType, null);
        this.pnlControls.add((Component)this.pnlRipple, null);
        this.pnlRipple.add((Component)this.lblRipple, null);
        this.pnlRipple.add((Component)this.tfRipple, null);
        this.pnlControls.add((Component)this.pnlFrequency, null);
        this.pnlFrequency.add((Component)this.lblFrequency, null);
        this.pnlFrequency.add((Component)this.tfFreq1, null);
        this.pnlFrequency.add((Component)this.lblTo, null);
        this.pnlFrequency.add((Component)this.tfFreq2, null);
        this.pnlControls.add((Component)this.pnlAtten, null);
        this.pnlAtten.add((Component)this.lblAtten, null);
        this.pnlAtten.add((Component)this.tfAtten, null);
        this.pnlControls.add((Component)this.pnlTransitionBandwidth, null);
        this.pnlTransitionBandwidth.add((Component)this.lblTransitionBandwidth, null);
        this.pnlTransitionBandwidth.add((Component)this.tfTransitionBandwidth, null);
        this.pnlControls.add((Component)this.pnlOrder, null);
        this.pnlOrder.add((Component)this.lblOrder, null);
        this.pnlOrder.add((Component)this.tfOrder, null);
        this.pnlOrder.add((Component)this.lblSpace, null);
        this.pnlOrder.add((Component)this.btnEstimate, null);
        this.pnlControls.add((Component)this.pnlMinPlotGain, null);
        this.pnlMinPlotGain.add((Component)this.lblMinPlotGain, null);
        this.pnlMinPlotGain.add((Component)this.chMinPlotGain, null);
        this.pnlControls.add((Component)this.pnlButtons, null);
        this.pnlButtons.add((Component)this.btnDesign, null);
        this.pnlButtons.add((Component)this.btnPlot, null);
        this.pnlButtons.add((Component)this.btnCoeffs, null);
        this.frPlot.setPlotStyle(2);
        this.frPlot.setTracePlot(true);
        this.frPlot.setLogScale(true);
        this.pnlControls.setLayout(this.gridLayout1);
        this.frPlot.setHorzIntervals(10);
        this.gridLayout1.setRows(4);
        this.gridLayout1.setColumns(2);
        this.flowLayout1.setAlignment(0);
        this.lblRipple.setFont(this.font);
        this.lblRipple.setText("Passband ripple (dB):        ");
        this.flowLayout2.setAlignment(0);
        this.tfRipple.setFont(this.font);
        this.tfRipple.setText("1");
        this.tfRipple.setColumns(4);
        this.tfRipple.addTextListener(new RemezFIRFilterDesign_tfRipple_textAdapter(this));
        this.lblOrder.setFont(this.font);
        this.lblOrder.setText("Order:");
        this.tfOrder.setFont(this.font);
        this.tfOrder.setColumns(4);
        this.tfOrder.addTextListener(new RemezFIRFilterDesign_tfOrder_textAdapter(this));
        this.tfOrder.addActionListener(new RemezFIRFilterDesign_tfOrder_actionAdapter(this));
        this.flowLayout3.setAlignment(0);
        this.lblAtten.setFont(this.font);
        this.lblAtten.setText("Stopband attenuation (dB):");
        this.tfAtten.setFont(this.font);
        this.tfAtten.setText("40");
        this.tfAtten.setColumns(4);
        this.tfAtten.addTextListener(new RemezFIRFilterDesign_tfAtten_textAdapter(this));
        this.flowLayout4.setAlignment(0);
        this.lblTransitionBandwidth.setFont(this.font);
        this.lblTransitionBandwidth.setText("Transition bandwidth: ");
        this.tfTransitionBandwidth.setFont(this.font);
        this.tfTransitionBandwidth.setText("0.02");
        this.tfTransitionBandwidth.setColumns(5);
        this.tfTransitionBandwidth.addTextListener(new RemezFIRFilterDesign_tfTransitionBandwidth_textAdapter(this));
        this.flowLayout5.setAlignment(0);
        this.flowLayout6.setAlignment(0);
        this.cbLP.setState(true);
        this.cbLP.setFont(this.font);
        this.cbLP.setLabel("LP");
        this.cbLP.setCheckboxGroup(this.cbgFilterType);
        this.cbLP.addItemListener(new RemezFIRFilterDesign_cbLP_itemAdapter(this));
        this.cbHP.setFont(this.font);
        this.cbHP.setLabel("HP");
        this.cbHP.setCheckboxGroup(this.cbgFilterType);
        this.cbHP.addItemListener(new RemezFIRFilterDesign_cbHP_itemAdapter(this));
        this.cbBP.setFont(this.font);
        this.cbBP.setLabel("BP");
        this.cbBP.setCheckboxGroup(this.cbgFilterType);
        this.cbBP.addItemListener(new RemezFIRFilterDesign_cbBP_itemAdapter(this));
        this.cbBS.setFont(this.font);
        this.cbBS.setLabel("BS");
        this.cbBS.setCheckboxGroup(this.cbgFilterType);
        this.cbBS.addItemListener(new RemezFIRFilterDesign_cbBS_itemAdapter(this));
        this.cbgFilterType.setSelectedCheckbox(this.cbLP);
        this.lblFrequency.setFont(this.font);
        this.lblFrequency.setText("Passband:");
        this.tfFreq1.setFont(this.font);
        this.tfFreq1.setText("0");
        this.tfFreq1.setEditable(false);
        this.tfFreq1.setColumns(5);
        this.tfFreq1.addTextListener(new RemezFIRFilterDesign_tfFreq1_textAdapter(this));
        this.lblTo.setFont(this.font);
        this.lblTo.setAlignment(1);
        this.lblTo.setText("to");
        this.tfFreq2.setFont(this.font);
        this.tfFreq2.setText("0.10");
        this.tfFreq2.setColumns(5);
        this.tfFreq2.addTextListener(new RemezFIRFilterDesign_tfFreq2_textAdapter(this));
        this.lblSpace.setText("    ");
        this.btnEstimate.setFont(this.font);
        this.btnEstimate.setLabel("Estimate");
        this.flowLayout8.setAlignment(0);
        this.lblMinPlotGain.setFont(this.font);
        this.lblMinPlotGain.setText("Minimum plot gain (dB):");
        this.chMinPlotGain.setFont(this.font);
        this.btnPlot.setEnabled(false);
        this.btnPlot.setFont(new Font("Dialog", 0, 11));
        this.btnPlot.setLabel("Plot response");
        this.btnPlot.addActionListener(new RemezFIRFilterDesign_btnPlot_actionAdapter(this));
        this.btnCoeffs.setEnabled(false);
        this.btnCoeffs.setFont(new Font("Dialog", 0, 11));
        this.btnCoeffs.setLabel("Coefficients");
        this.btnCoeffs.addActionListener(new RemezFIRFilterDesign_btnCoeffs_actionAdapter(this));
        this.chMinPlotGain.addItem("-10");
        this.chMinPlotGain.addItem("-50");
        this.chMinPlotGain.addItem("-100");
        this.chMinPlotGain.addItem("-200");
        this.chMinPlotGain.select("-100");
        this.chMinPlotGain.addItemListener(new RemezFIRFilterDesign_chMinPlotGain_itemAdapter(this));
        this.pnlMinPlotGain.setLayout(this.flowLayout8);
        this.btnEstimate.addActionListener(new RemezFIRFilterDesign_btnEstimate_actionAdapter(this));
        this.btnDesign.setEnabled(false);
        this.btnDesign.setFont(this.font);
        this.btnDesign.setLabel("Design");
        this.btnDesign.addActionListener(new RemezFIRFilterDesign_btnDesign_actionAdapter(this));
        this.pnlButtons.setLayout(this.flowLayout6);
        this.pnlOrder.setLayout(this.flowLayout5);
        this.pnlTransitionBandwidth.setLayout(this.flowLayout4);
        this.pnlAtten.setLayout(this.flowLayout3);
        this.pnlFrequency.setLayout(this.flowLayout2);
        this.pnlRipple.setLayout(this.flowLayout1);
    }

    public String getAppletInfo() {
        return "(C) 1998 Dr Iain A Robin (i.robin@bell.ac.uk)\n\nDerived from\n\nParks-McClellan algorithm for FIR filter design (C version)\nCopyright (C) 1995  Jake Janovetz (janovetz@coewl.cen.uiuc.edu)";
    }

    public String[][] getParameterInfo() {
        return null;
    }

    double log10(double x) {
        return Math.log(x) / Math.log(10.0);
    }

    double minPlotGain() {
        return Math.abs(Double.valueOf(this.chMinPlotGain.getSelectedItem()));
    }

    public double[] filterGain(int freqPoints) {
        double[] g = new double[freqPoints + 1];
        double t = Math.PI / (double)freqPoints;
        this.order = this.numTaps - 1;
        int i = 0;
        while (i <= freqPoints) {
            double theta = (double)i * t;
            double sac = 0.0;
            double sas = 0.0;
            int k = 0;
            while (k <= this.order) {
                double c = Math.cos((double)k * theta);
                double s = Math.sin((double)k * theta);
                sac += c * this.a[k];
                sas += s * this.a[k];
                ++k;
            }
            g[i] = 10.0 * this.log10(sac * sac + sas * sas);
            ++i;
        }
        return g;
    }

    void setDisplayEnabled(boolean b) {
        this.btnPlot.setEnabled(b);
        this.btnCoeffs.setEnabled(b);
        this.chMinPlotGain.setEnabled(b);
    }

    void plotResponse() {
        this.gain = this.filterGain(freqPoints);
        this.frPlot.setYmax(this.minPlotGain());
        this.frPlot.setPlotValues(this.gain);
        this.cardLayout1.show(this.pnlDisplay, "FRPlot");
    }

    void listCoeffs() {
        this.txtCoeffs.setText("Parks-McClellan FIR Filter Design\n\n");
        String filterType = new String();
        if (this.lp) {
            filterType = "Low pass";
        }
        if (this.hp) {
            filterType = "High pass";
        }
        if (this.bp) {
            filterType = "Band pass";
        }
        if (this.bs) {
            filterType = "Band stop";
        }
        this.txtCoeffs.append("Filter type: " + filterType + "\n");
        if (!this.bs) {
            this.txtCoeffs.append("Passband: ");
        } else {
            this.txtCoeffs.append("Stopband: ");
        }
        this.txtCoeffs.append(String.valueOf(this.tfFreq1.getText()) + " - " + this.tfFreq2.getText() + "\n");
        this.txtCoeffs.append("Order: " + String.valueOf(this.order) + "\n");
        this.txtCoeffs.append("Passband ripple: " + String.valueOf(this.ripple) + " dB\n");
        this.txtCoeffs.append("Transition band: " + String.valueOf(this.trband) + "\n");
        this.txtCoeffs.append("Stopband attenuation: " + String.valueOf(this.atten) + " dB\n\n");
        this.txtCoeffs.append("Coefficients:\n\n");
        int i = 0;
        while (i <= this.order) {
            this.txtCoeffs.append("a[" + String.valueOf(i) + "] =\t" + String.valueOf(String.valueOf(this.a[i]) + "\n"));
            ++i;
        }
        this.cardLayout1.show(this.pnlDisplay, "Coeffs");
    }

    void setParameters() {
        this.ripple = Double.valueOf(this.tfRipple.getText());
        this.atten = Double.valueOf(this.tfAtten.getText());
        this.deltaP = 0.5 * (1.0 - Math.pow(10.0, -0.05 * this.ripple));
        this.deltaS = Math.pow(10.0, -0.05 * this.atten);
        this.rippleRatio = this.deltaP / this.deltaS;
        this.trband = Double.valueOf(this.tfTransitionBandwidth.getText());
    }

    void btnEstimate_actionPerformed(ActionEvent e) {
        this.setParameters();
        int order = (int)Math.round((-10.0 * this.log10(this.deltaP * this.deltaS) - 13.0) / (14.6 * this.trband));
        this.tfOrder.setText(String.valueOf(order));
        this.btnDesign.setEnabled(true);
        this.setDisplayEnabled(false);
    }

    void design() {
        this.numTaps = Integer.parseInt(this.tfOrder.getText()) + 1;
        this.a = new double[this.numTaps];
        double f1 = Double.valueOf(this.tfFreq1.getText());
        double f2 = Double.valueOf(this.tfFreq2.getText());
        this.lp = this.cbLP.getState();
        this.hp = this.cbHP.getState();
        this.bp = this.cbBP.getState();
        this.bs = this.cbBS.getState();
        if (this.lp || this.hp) {
            this.numBands = 2;
        }
        if (this.bp || this.bs) {
            this.numBands = 3;
        }
        this.desired = new double[this.numBands];
        this.bands = new double[2 * this.numBands];
        this.weights = new double[this.numBands];
        if (this.lp) {
            this.desired[0] = 1.0;
            this.desired[1] = 0.0;
            this.bands[0] = 0.0;
            this.bands[1] = f2;
            this.bands[2] = f2 + this.trband;
            this.bands[3] = 0.5;
            this.weights[0] = 1.0;
            this.weights[1] = this.rippleRatio;
        }
        if (this.hp) {
            this.desired[0] = 0.0;
            this.desired[1] = 1.0;
            this.bands[0] = 0.0;
            this.bands[1] = f1 - this.trband;
            this.bands[2] = f1;
            this.bands[3] = 0.5;
            this.weights[0] = this.rippleRatio;
            this.weights[1] = 1.0;
        }
        if (this.bp) {
            this.desired[0] = 0.0;
            this.desired[1] = 1.0;
            this.desired[2] = 0.0;
            this.bands[0] = 0.0;
            this.bands[1] = f1 - this.trband;
            this.bands[2] = f1;
            this.bands[3] = f2;
            this.bands[4] = f2 + this.trband;
            this.bands[5] = 0.5;
            this.weights[0] = this.rippleRatio;
            this.weights[1] = 1.0;
            this.weights[2] = this.rippleRatio;
        }
        if (this.bs) {
            this.desired[0] = 1.0;
            this.desired[1] = 0.0;
            this.desired[2] = 1.0;
            this.bands[0] = 0.0;
            this.bands[1] = f1 - this.trband;
            this.bands[2] = f1;
            this.bands[3] = f2;
            this.bands[4] = f2 + this.trband;
            this.bands[5] = 0.5;
            this.weights[0] = 1.0;
            this.weights[1] = this.rippleRatio;
            this.weights[2] = 1.0;
        }
        this.a = this.rf.remez(this.numTaps, this.bands, this.desired, this.weights, 1);
        this.order = this.numTaps - 1;
    }

    void btnDesign_actionPerformed(ActionEvent e) {
        this.design();
        this.setDisplayEnabled(true);
    }

    void tfRipple_textValueChanged(TextEvent e) {
        this.btnDesign.setEnabled(false);
        this.setDisplayEnabled(false);
    }

    void tfAtten_textValueChanged(TextEvent e) {
        this.btnDesign.setEnabled(false);
        this.setDisplayEnabled(false);
    }

    void tfTransitionBandwidth_textValueChanged(TextEvent e) {
        this.btnDesign.setEnabled(false);
        this.setDisplayEnabled(false);
    }

    void cbLP_itemStateChanged(ItemEvent e) {
        if (this.cbLP.getState()) {
            this.tfFreq1.setEditable(false);
            this.tfFreq1.setText("0");
            this.tfFreq2.setEditable(true);
            this.tfFreq2.selectAll();
            this.tfFreq2.requestFocus();
            this.lblFrequency.setText("Passband:");
            this.setDisplayEnabled(false);
        }
    }

    void cbHP_itemStateChanged(ItemEvent e) {
        if (this.cbHP.getState()) {
            this.tfFreq1.setEditable(true);
            this.tfFreq1.selectAll();
            this.tfFreq1.requestFocus();
            this.tfFreq2.setEditable(false);
            this.tfFreq2.setText("0.5");
            this.lblFrequency.setText("Passband:");
            this.setDisplayEnabled(false);
        }
    }

    void cbBP_itemStateChanged(ItemEvent e) {
        if (this.cbBP.getState()) {
            this.tfFreq1.setEditable(true);
            this.tfFreq1.selectAll();
            this.tfFreq1.requestFocus();
            this.tfFreq2.setEditable(true);
            this.tfFreq2.setText("0.5");
            this.lblFrequency.setText("Passband:");
            this.setDisplayEnabled(false);
        }
    }

    void cbBS_itemStateChanged(ItemEvent e) {
        if (this.cbBS.getState()) {
            this.tfFreq1.setEditable(true);
            this.tfFreq1.selectAll();
            this.tfFreq1.requestFocus();
            this.tfFreq2.setEditable(true);
            this.tfFreq2.setText("0.5");
            this.lblFrequency.setText("Stopband:");
            this.setDisplayEnabled(false);
        }
    }

    void chMinPlotGain_itemStateChanged(ItemEvent e) {
        this.plotResponse();
    }

    void btnPlot_actionPerformed(ActionEvent e) {
        this.plotResponse();
    }

    void btnCoeffs_actionPerformed(ActionEvent e) {
        this.listCoeffs();
    }

    void tfOrder_actionPerformed(ActionEvent e) {
        this.setParameters();
        this.btnDesign.setEnabled(true);
        this.setDisplayEnabled(false);
    }

    void tfOrder_textValueChanged(TextEvent e) {
        this.setDisplayEnabled(false);
    }

    void tfFreq1_textValueChanged(TextEvent e) {
        this.setDisplayEnabled(false);
    }

    void tfFreq2_textValueChanged(TextEvent e) {
        this.setDisplayEnabled(false);
    }
}

