/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.seismograph;

import cn.org.gddsn.signal.Filter;
import java.io.File;
import java.util.Scanner;

public class ChinaIntensity {
    private static final double[] ACC = new double[]{22.0, 45.0, 90.0, 178.0, 354.0, 708.0, 1415.0};
    private static final double[] VEL = new double[]{2.0, 5.0, 10.0, 19.0, 36.0, 72.0, 142.0};
    public static final int RAW_DATA_ACC = 0;
    public static final int RAW_DATA_VEL = 1;
    private static final double[] B_ACC = new double[]{0.00834867625727445, -0.01669735251454897, -0.00834867625727444, 0.0333947050290979, -0.00834867625727456, -0.01669735251454896, 0.0083486762572745};
    private static final double[] A_ACC = new double[]{1.0, -5.675724687915398, 13.426739533949046, -16.947817334925105, 12.040302308933102, -4.565486790486275, 0.721986973736476};
    private static final double[] B_VEL = new double[]{0.960929912120873, -2.238172765310702, -0.972921001118379, 5.449266531823273, -1.581564705261277, -4.184014767714444, 2.238172765394197, 0.972921001201873, -0.644616971135414};
    private static final double[] A_VEL = new double[]{1.0, -4.816334987915398, 8.44697914011884, -4.829518184989339, -3.895361644662867, 7.512215062435825, -4.430872941835097, 1.0866091957914839, -0.0737156331587254};

    private ChinaIntensity() {
    }

    public static int getIntensity(double[] ud, double[] ns, double[] ew, int rdt) {
        if (ud.length < 50) {
            return -1;
        }
        double[] a = new double[ud.length];
        ChinaIntensity.intensityFilter(ud, rdt);
        ChinaIntensity.intensityFilter(ns, rdt);
        ChinaIntensity.intensityFilter(ew, rdt);
        double maxA = -1.0;
        int i = 0;
        while (i < a.length) {
            a[i] = Math.sqrt(ud[i] * ud[i] + ns[i] * ns[i] + ew[i] * ew[i]);
            if (maxA < a[i]) {
                maxA = a[i];
            }
            ++i;
        }
        double a0 = 0.0;
        double a1 = maxA;
        do {
            int n = 0;
            double mid = (a0 + a1) / 2.0;
            int i2 = 0;
            while (i2 < a.length) {
                if (a[i2] > mid) {
                    ++n;
                }
                ++i2;
            }
            if (n < 50) {
                a1 = mid;
                continue;
            }
            a0 = mid;
        } while (Math.abs(a1 - a0) > 0.05);
        System.out.println(a0);
        return ChinaIntensity.getIntensity(a0);
    }

    private static void intensityFilter(double[] smps, int rdt) {
        double[] a;
        double[] b;
        if (rdt == 0) {
            b = B_ACC;
            a = A_ACC;
        } else if (rdt == 1) {
            b = B_VEL;
            a = A_VEL;
        } else {
            throw new IllegalArgumentException("Invalid RDT value!");
        }
        Filter f = new Filter(b, a);
        int i = 0;
        while (i < 1600) {
            f.filter(smps[0]);
            ++i;
        }
        i = 0;
        while (i < smps.length) {
            smps[i] = f.filter(smps[i]);
            ++i;
        }
    }

    public static int getIntensity(double a05) {
        double intensity = 2.71 * Math.log10(a05) + 2.39;
        return (int)Math.round(intensity);
    }

    public static double chinaFilter(double f) {
        double a = 0.8064;
        double s1 = 0.54;
        double f1 = 0.28;
        double s2 = 1.0;
        double f2 = 2.15;
        double num = 0.8064 * f * f * f * f * (20.648844809999993 + 4.0 * f * f * -1.9988 * -1.9988);
        double den1 = (f * f - 0.07840000000000001) * (f * f - 0.07840000000000001) + 0.09144576000000003 * f * f;
        double den2 = (f * f - 4.6225) * (f * f - 4.6225) + 18.49 * f * f;
        return num / (den1 + den2);
    }

    public static int getIntensity(double acc, double vel) {
        int iacc = ChinaIntensity.getIntensityByAcc(acc);
        int ivel = ChinaIntensity.getIntensityByVel(vel);
        return Math.max(iacc, ivel);
    }

    private static int getIntensityByAcc(double acc) {
        if (acc > ACC[6]) {
            return 11;
        }
        if (acc > ACC[5]) {
            return 10;
        }
        if (acc > ACC[4]) {
            return 9;
        }
        if (acc > ACC[3]) {
            return 8;
        }
        if (acc > ACC[2]) {
            return 7;
        }
        if (acc > ACC[1]) {
            return 6;
        }
        if (acc > ACC[0]) {
            return 5;
        }
        return 4;
    }

    private static int getIntensityByVel(double vel) {
        if (vel > VEL[6]) {
            return 11;
        }
        if (vel > VEL[5]) {
            return 10;
        }
        if (vel > VEL[4]) {
            return 9;
        }
        if (vel > VEL[3]) {
            return 8;
        }
        if (vel > VEL[2]) {
            return 7;
        }
        if (vel > VEL[1]) {
            return 6;
        }
        if (vel > VEL[0]) {
            return 5;
        }
        return 4;
    }

    public static void main(String[] args) throws Exception {
        Scanner sc = new Scanner(new File("/tmp/aa.txt"));
        int n = 12000;
        double[] ud = new double[n];
        double[] ns = new double[n];
        double[] ew = new double[n];
        int i = 0;
        while (i < n) {
            ud[i] = sc.nextDouble() / 100000.0;
            ns[i] = sc.nextDouble() / 100000.0;
            ew[i] = sc.nextDouble() / 100000.0;
            ++i;
        }
    }
}

