/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.seismograph;

import JSci.maths.ArrayMath;
import cn.org.gddsn.seis.evtformat.EvtData;
import cn.org.gddsn.seis.evtformat.TransferFun;
import cn.org.gddsn.signal.FFT;
import com.nr.Complex;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Emulate {
    public static final int LPSRO = 1;
    public static final int KIRNOS = 2;
    public static final int WWSSNLP = 3;
    public static final int WWSSNSP = 4;
    public static final int WA = 5;
    public static final TransferFun LPSRO_PZ = new TransferFun("LPSRO", 92384.54528458492, 0.04, 7, 9, new Complex[]{new Complex(-0.1243, 0.0), new Complex(-47.62, 0.0), new Complex(0.0, 0.0), new Complex(0.0, 0.0), new Complex(0.0, 0.0), new Complex(0.0, 0.0), new Complex(0.0, 0.0)}, new Complex[]{new Complex(-4.648, 3.463), new Complex(-4.648, -3.463), new Complex(-0.1179, 0.0), new Complex(-40.73, 0.0), new Complex(-100.0, 0.0), new Complex(-0.15, 0.0), new Complex(-264.0, 0.0), new Complex(-3.928, 0.0), new Complex(-0.282, 0.0), new Complex(-0.201, 0.241), new Complex(-0.201, -0.241), new Complex(-0.1337, 0.1001), new Complex(-0.1337, -0.1001), new Complex(-0.0251, 0.0), new Complex(-0.00924, 0.0), new Complex(-0.8547, 0.2555), new Complex(-0.8547, -0.2555), new Complex(-0.5415, 0.6834), new Complex(-0.5415, -0.6834)});
    public static final TransferFun KIRNOS_PZ = new TransferFun("SK", 83.559, 0.5, 3, 4, new Complex[]{new Complex(0.0, 0.0), new Complex(0.0, 0.0), new Complex(0.0, 0.0)}, new Complex[]{new Complex(-0.127, 0.25), new Complex(-0.127, -0.25), new Complex(-0.263, 0.0), new Complex(-83.6, 0.0)});
    public static final TransferFun WA_PZ = new TransferFun("W.A.", 0.999375, 10.0, 2, 2, new Complex[]{new Complex(0.0, 0.0), new Complex(0.0, 0.0)}, new Complex[]{new Complex(-5.4192, 5.6848), new Complex(-5.4192, -5.6848)});
    public static final TransferFun WWSSNLP_PZ = new TransferFun("763", 0.84546, 0.06666666666666667, 3, 4, new Complex[]{new Complex(0.0, 0.0), new Complex(0.0, 0.0), new Complex(0.0, 0.0)}, new Complex[]{new Complex(-0.411, 0.0252), new Complex(-0.411, -0.0252), new Complex(-0.0486, 0.0), new Complex(-0.0874, 0.0)});
    public static final TransferFun WWSSNSP_PZ = new TransferFun("WWSSSP", 531.98, 1.0, 3, 5, new Complex[]{new Complex(0.0, 0.0), new Complex(0.0, 0.0), new Complex(0.0, 0.0)}, new Complex[]{new Complex(-3.73, 6.22), new Complex(-3.73, -6.22), new Complex(-5.61, 0.0), new Complex(-13.2, 0.0), new Complex(-21.1, 0.0)});

    double[] taper(double[] fr, int n, int perc) {
        int nz = (int)((double)(n * perc) / 100.0);
        double x = 1.5707963267948966 / (double)nz;
        int m = 0;
        while (m < nz) {
            fr[m] = fr[m] * (double)((float)Math.sin((double)m * x));
            ++m;
        }
        m = n - nz;
        while (m < n) {
            fr[m] = fr[m] * (double)((float)Math.sin((double)(n - m) * x));
            ++m;
        }
        return fr;
    }

    private Complex response(int nz, int np, double freq, Complex[] z, Complex[] p) {
        Complex rsp = new Complex(1.0, 0.0);
        Complex jomg = new Complex(0.0, Math.PI * 2 * freq);
        Complex c = new Complex(0.0, 0.0);
        int i = 0;
        while (i < nz) {
            c = jomg.sub(z[i]);
            rsp = rsp.mul(c);
            ++i;
        }
        i = 0;
        while (i < np) {
            c = jomg.sub(p[i]);
            rsp = rsp.div(c);
            ++i;
        }
        return rsp;
    }

    private double normalf(EvtData evt, int chn, double freq) {
        Complex rsp = new Complex(1.0, 0.0);
        Complex jomg = new Complex(0.0, Math.PI * 2 * freq);
        Complex c = new Complex(0.0, 0.0);
        Complex[] zero = evt.getZero(chn);
        int i = 0;
        while (i < evt.getZeroNum(chn)) {
            c = jomg.sub(zero[i]);
            rsp = rsp.mul(c);
            ++i;
        }
        Complex[] pole = evt.getPole(chn);
        i = 0;
        while (i < evt.getPoleNum(chn)) {
            c = jomg.sub(pole[i]);
            rsp = rsp.div(c);
            ++i;
        }
        return rsp.mod() * evt.getScaleFactor(chn);
    }

    public boolean emulate(EvtData evt, int chn, int type) {
        TransferFun tf = null;
        switch (type) {
            case 1: {
                tf = LPSRO_PZ;
                break;
            }
            case 2: {
                tf = KIRNOS_PZ;
                break;
            }
            case 3: {
                tf = WWSSNLP_PZ;
                break;
            }
            case 4: {
                tf = WWSSNSP_PZ;
                break;
            }
            case 5: {
                tf = WA_PZ;
                break;
            }
            default: {
                return false;
            }
        }
        return this.emulate(evt, chn, tf);
    }

    public boolean emulate(EvtData evt, int chn, TransferFun tf) {
        int nfft = 8;
        int zc = 0;
        Complex c = new Complex(0.0, 0.0);
        Complex b = new Complex(0.0, 0.0);
        Complex a = new Complex(0.0, 0.0);
        int samp = evt.getSamples(chn);
        while (samp >= nfft) {
            nfft *= 2;
        }
        double[] re = new double[nfft];
        double[] im = new double[nfft];
        double A0 = tf.a0;
        double F0 = tf.f0;
        int np = tf.iNumPoles;
        int nz = tf.iNumZeros;
        Complex[] p = tf.poles;
        Complex[] z = tf.zeros;
        evt.setInstrumentType(chn, tf.instrument);
        double mean = ArrayMath.mean((double[])evt.getSampData(chn));
        int i = 0;
        while (i < nfft) {
            re[i] = i < samp ? evt.getSampData(chn)[i] - mean : 0.0;
            im[i] = 0.0;
            ++i;
        }
        if (evt.getOriginalType(chn) == 1) {
            evt.setOriginalType(chn, 0);
            zc = 1;
        } else if (evt.getOriginalType(chn) == 2) {
            evt.setOriginalType(chn, 0);
            zc = 2;
        } else {
            zc = 0;
        }
        evt.setCalibFactor(chn, evt.getCalibFactor(chn) * 100.0 * this.normalf(evt, chn, F0));
        evt.setCalper(chn, F0);
        FFT afft = new FFT();
        afft.doFFT(re, im, nfft, -1);
        re = afft.getReal();
        im = afft.getIm();
        i = 0;
        while (i <= nfft / 2) {
            double freq = (double)i / (double)nfft * evt.getSampleRate(chn);
            a = new Complex(re[i], im[i]);
            b = this.response(nz - zc, np, freq, z, p);
            c = a.mul(b);
            re[i] = c.re() * A0;
            im[i] = c.im() * A0;
            if (i != 0 && i != nfft / 2) {
                re[nfft - i] = re[i];
                im[nfft - i] = -im[i];
            }
            ++i;
        }
        afft.doFFT(re, im, nfft, 1);
        re = afft.getReal();
        i = 0;
        while (i < samp) {
            int n = i++;
            re[n] = re[n] * 100.0;
        }
        evt.setSampData(chn, re);
        zc = 0;
        int new_np = evt.getPoleNum(chn) + np;
        int new_nz = evt.getZeroNum(chn) + nz - zc;
        Complex[] new_pole = new Complex[new_np];
        Complex[] new_zero = new Complex[new_nz];
        i = 0;
        while (i < evt.getPoleNum(chn)) {
            new_pole[i] = evt.getPole(chn)[i];
            ++i;
        }
        i = 0;
        while (i < evt.getZeroNum(chn)) {
            new_zero[i] = evt.getZero(chn)[i];
            ++i;
        }
        Complex ctemp = null;
        i = 0;
        while (i < nz - zc) {
            new_zero[evt.getZeroNum((int)chn) + i] = ctemp = z[i].mul(1.0);
            ++i;
        }
        i = 0;
        while (i < np) {
            new_pole[evt.getPoleNum((int)chn) + i] = ctemp = p[i].mul(1.0);
            ++i;
        }
        evt.setCalper(chn, F0);
        evt.setScaleFactor(chn, 1.0 / this.normalf(evt, chn, F0) * evt.getScaleFactor(chn));
        evt.setPole(chn, new_pole);
        evt.setZero(chn, new_zero);
        return true;
    }

    public List<double[]> emulateWA(EvtData evt, int chn, int start, int end, double mean) {
        int nfft = 8;
        int zc = 0;
        Complex c = new Complex(0.0, 0.0);
        Complex b = new Complex(0.0, 0.0);
        Complex a = new Complex(0.0, 0.0);
        int wDatLengh = end - start;
        double[] wDat = new double[wDatLengh];
        System.arraycopy(evt.getSampData(chn), start, wDat, 0, wDatLengh);
        while (wDatLengh >= nfft) {
            nfft *= 2;
        }
        double[] re = new double[nfft];
        double[] im = new double[nfft];
        double A0 = Emulate.WA_PZ.a0;
        double F0 = Emulate.WA_PZ.f0;
        int np = Emulate.WA_PZ.iNumPoles;
        int nz = Emulate.WA_PZ.iNumZeros;
        Complex[] p = Emulate.WA_PZ.poles;
        Complex[] z = Emulate.WA_PZ.zeros;
        int i = 0;
        while (i < nfft) {
            re[i] = i < wDatLengh ? wDat[i] - mean : 0.0;
            im[i] = 0.0;
            ++i;
        }
        zc = evt.getOriginalType(chn) == 1 ? 1 : (evt.getOriginalType(chn) == 2 ? 2 : 0);
        double[] calibFactor = new double[]{evt.getCalibFactor(chn) * 100.0 * this.normalf(evt, chn, F0)};
        FFT afft = new FFT();
        afft.doFFT(re, im, nfft, -1);
        re = afft.getReal();
        im = afft.getIm();
        i = 0;
        while (i <= nfft / 2) {
            double freq = (double)i / (double)nfft * evt.getSampleRate(chn);
            a = new Complex(re[i], im[i]);
            b = this.response(nz - zc, np, freq, z, p);
            c = a.mul(b);
            re[i] = c.re() * A0;
            im[i] = c.im() * A0;
            if (i != 0 && i != nfft / 2) {
                re[nfft - i] = re[i];
                im[nfft - i] = -im[i];
            }
            ++i;
        }
        afft.doFFT(re, im, nfft, 1);
        re = afft.getReal();
        i = 0;
        while (i < wDatLengh) {
            int n = i++;
            re[n] = re[n] * 100.0;
        }
        ArrayList<double[]> result = new ArrayList<double[]>(2);
        result.add(re);
        result.add(calibFactor);
        return result;
    }
}

