/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.seismograph;

import cn.org.gddsn.seis.evtformat.sac.SAC;
import cn.org.gddsn.signal.cfft99.Fft991;
import cn.org.gddsn.signal.seismograph.PrepFFT;
import java.io.File;
import java.io.IOException;
import java.util.InputMismatchException;
import java.util.NoSuchElementException;
import java.util.Scanner;
import org.apache.log4j.Logger;

public class Transfer {
    static Logger logger = Logger.getLogger(Transfer.class);
    public static final int NFFT_TEST = 1024;
    public static final double ALIAS_CUTOFF = 0.01;

    private Transfer() {
    }

    public static int readSacPZ(String pzFile, ResponseStruct pRS) {
        int rc = 0;
        try {
            Scanner sc = new Scanner(new File(pzFile));
            while (sc.hasNext()) {
                int i;
                String key = sc.next();
                if (key.startsWith("#")) {
                    sc.skip(".*\n");
                    continue;
                }
                if (key.equals("ZEROS")) {
                    pRS.iNumZeros = sc.nextInt();
                    pRS.Zeros = new PZNum[pRS.iNumZeros];
                    i = 0;
                    while (i < pRS.iNumZeros) {
                        pRS.Zeros[i] = new PZNum();
                        pRS.Zeros[i].dReal = 0.0;
                        pRS.Zeros[i].dImag = 0.0;
                        ++i;
                    }
                    i = 0;
                    while (i < pRS.iNumZeros) {
                        key = sc.next();
                        if (key.equals("POLES") || key.equals("CONSTANT")) break;
                        pRS.Zeros[i].dReal = Double.parseDouble(key);
                        pRS.Zeros[i].dImag = sc.nextDouble();
                        ++i;
                    }
                }
                if (key.equals("POLES")) {
                    pRS.iNumPoles = sc.nextInt();
                    pRS.Poles = new PZNum[pRS.iNumPoles];
                    i = 0;
                    while (i < pRS.iNumPoles) {
                        pRS.Poles[i] = new PZNum();
                        pRS.Poles[i].dReal = sc.nextDouble();
                        pRS.Poles[i].dImag = sc.nextDouble();
                        ++i;
                    }
                }
                if (!key.equals("CONSTANT")) continue;
                pRS.dGain = sc.nextDouble();
            }
            sc.close();
        }
        catch (IOException ioEx) {
            rc = -4;
        }
        catch (InputMismatchException imEx) {
            rc = -3;
        }
        catch (NoSuchElementException nseEx) {
            rc = -2;
        }
        return rc;
    }

    public static void response(int nfft, double deltat, ResponseStruct pRS, double[] tfr, double[] tfi) {
        double si0;
        double sr0;
        double si;
        double sr;
        int ntr = nfft / 2 + 1;
        double delomg = Math.PI * 2 / ((double)nfft * deltat);
        double srn = 1.0;
        double sin = 0.0;
        double omega = delomg * 0.001;
        int j = 0;
        while (j < pRS.iNumZeros) {
            sr = -pRS.Zeros[j].dReal;
            si = omega - pRS.Zeros[j].dImag;
            sr0 = srn * sr - sin * si;
            si0 = srn * si + sin * sr;
            srn = sr0;
            sin = si0;
            ++j;
        }
        double srd = 1.0;
        double sid = 0.0;
        j = 0;
        while (j < pRS.iNumPoles) {
            sr = -pRS.Poles[j].dReal;
            si = omega - pRS.Poles[j].dImag;
            sr0 = srd * sr - sid * si;
            si0 = srd * si + sid * sr;
            srd = sr0;
            sid = si0;
            ++j;
        }
        double mag2 = pRS.dGain / (srd * srd + sid * sid);
        tfr[0] = mag2 * (srn * srd + sin * sid);
        tfi[0] = 0.0;
        int i = 1;
        while (i < ntr) {
            srn = 1.0;
            sin = 0.0;
            omega = delomg * (double)i;
            j = 0;
            while (j < pRS.iNumZeros) {
                sr = -pRS.Zeros[j].dReal;
                si = omega - pRS.Zeros[j].dImag;
                sr0 = srn * sr - sin * si;
                si0 = srn * si + sin * sr;
                srn = sr0;
                sin = si0;
                ++j;
            }
            srd = 1.0;
            sid = 0.0;
            j = 0;
            while (j < pRS.iNumPoles) {
                sr = -pRS.Poles[j].dReal;
                si = omega - pRS.Poles[j].dImag;
                sr0 = srd * sr - sid * si;
                si0 = srd * si + sid * sr;
                srd = sr0;
                sid = si0;
                ++j;
            }
            mag2 = pRS.dGain / (srd * srd + sid * sid);
            tfr[i] = mag2 * (srn * srd + sin * sid);
            tfi[i] = mag2 * (sin * srd - srn * sid);
            ++i;
        }
    }

    public static double ftaper(double freq, double fon, double foff) {
        double pi = Math.PI;
        double t = fon > foff ? (freq < foff ? 0.0 : (freq > fon ? 1.0 : 0.5 * (1.0 - Math.cos(pi * (freq - foff) / (fon - foff))))) : (fon < foff ? (freq < fon ? 1.0 : (freq > foff ? 0.0 : 0.5 * (1.0 + Math.cos(pi * (freq - fon) / (foff - fon))))) : 1.0);
        return t;
    }

    int convertWave(double[] input, int npts, double deltat, ResponseStruct origRS, ResponseStruct finalRS, double[] freq, int retFD, int[] pPadLen, int[] pnfft, double[] output, int outBufLen, double[] fre, double[] fim, double[] workFFT) {
        double dre;
        double tpr;
        double f;
        int nfft;
        ResponseStruct rs = new ResponseStruct();
        PrepFFT.FACT[] pfact = new PrepFFT.FACT[1];
        int retval = 0;
        int nz = 0;
        int np = 0;
        if (origRS == null || finalRS == null || npts < 2 || deltat <= 0.0 || freq == null || outBufLen < npts) {
            return -3;
        }
        if (freq[0] > freq[1] || freq[1] >= freq[2] || freq[2] > freq[3] || origRS.dGain == 0.0 || finalRS.dGain == 0.0) {
            return -3;
        }
        rs.dGain = finalRS.dGain / origRS.dGain;
        rs.iNumPoles = finalRS.iNumPoles + origRS.iNumZeros;
        rs.iNumZeros = finalRS.iNumZeros + origRS.iNumPoles;
        rs.Poles = new PZNum[rs.iNumPoles];
        rs.Zeros = new PZNum[rs.iNumZeros];
        int i = 0;
        while (i < origRS.iNumPoles) {
            rs.Zeros[nz++] = origRS.Poles[i];
            ++i;
        }
        i = 0;
        while (i < origRS.iNumZeros) {
            rs.Poles[np++] = origRS.Zeros[i];
            ++i;
        }
        i = 0;
        while (i < finalRS.iNumPoles) {
            rs.Poles[np++] = finalRS.Poles[i];
            ++i;
        }
        i = 0;
        while (i < finalRS.iNumZeros) {
            rs.Zeros[nz++] = finalRS.Zeros[i];
            ++i;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Input response function: gain %10.3e\n", origRS.dGain));
            logger.debug((Object)String.format("Poles: %d\n", origRS.iNumPoles));
            i = 0;
            while (i < origRS.iNumPoles) {
                logger.debug((Object)String.format("%10.3e   %10.3e\n", origRS.Poles[i].dReal, origRS.Poles[i].dImag));
                ++i;
            }
            logger.debug((Object)String.format("\nZeros: %d\n", origRS.iNumZeros));
            i = 0;
            while (i < origRS.iNumZeros) {
                logger.debug((Object)String.format("%10.3e   %10.3e\n", origRS.Zeros[i].dReal, origRS.Zeros[i].dImag));
                ++i;
            }
            logger.debug((Object)String.format("\nOutput response function: gain %10.3e\n", finalRS.dGain));
            logger.debug((Object)String.format("Poles: %d\n", finalRS.iNumPoles));
            i = 0;
            while (i < finalRS.iNumPoles) {
                logger.debug((Object)String.format("%10.3e   %10.3e\n", finalRS.Poles[i].dReal, finalRS.Poles[i].dImag));
                ++i;
            }
            logger.debug((Object)String.format("\nZeros: %d\n", finalRS.iNumZeros));
            i = 0;
            while (i < finalRS.iNumZeros) {
                logger.debug((Object)String.format("%10.3e   %10.3e\n", finalRS.Zeros[i].dReal, finalRS.Zeros[i].dImag));
                ++i;
            }
        }
        if (pPadLen[0] < 0) {
            pPadLen[0] = Transfer.respLen(rs, deltat, freq);
            if (pPadLen[0] < 0) {
                retval = pPadLen[0];
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("\nrespLen error: %ld\n", pPadLen[0]));
                }
                Transfer.cleanPZ(rs);
                return retval;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("estimated pad length: %ld\n", pPadLen[0]));
            }
        }
        int trial_nfft = pPadLen[0] + npts;
        while ((nfft = PrepFFT.prepFFT(trial_nfft, pfact)) > outBufLen) {
            if (nfft < 0) {
                retval = nfft;
                Transfer.cleanPZ(rs);
                return retval;
            }
            trial_nfft -= 100;
        }
        if (nfft - pPadLen[0] < npts) {
            npts = nfft - pPadLen[0];
        }
        int nfreq = nfft / 2 + 1;
        i = 0;
        while (i < npts) {
            output[i] = input[i];
            ++i;
        }
        i = outBufLen + 2;
        while (i < nfft) {
            output[i] = 0.0;
            ++i;
        }
        Fft991.fft991(output, 0, workFFT, 0, pfact[0].trigs, 0, pfact[0].ifax, 0, 1, nfft, nfft, 1, -1);
        Transfer.response(nfft, deltat, rs, fre, fim);
        double delfreq = 1.0 / ((double)nfft * deltat);
        output[0] = 0.0;
        i = 1;
        while (i < nfreq - 1) {
            int ii = i + i;
            f = (double)i * delfreq;
            tpr = Transfer.ftaper(f, freq[1], freq[0]) * Transfer.ftaper(f, freq[2], freq[3]);
            dre = output[ii];
            double dim = output[ii + 1];
            output[ii] = (dre * fre[i] - dim * fim[i]) * tpr;
            output[ii + 1] = (dre * fim[i] + dim * fre[i]) * tpr;
            ++i;
        }
        f = (double)i * delfreq;
        tpr = Transfer.ftaper(f, freq[1], freq[0]) * Transfer.ftaper(f, freq[2], freq[3]);
        dre = output[nfft];
        output[nfft] = dre * fre[i] * tpr;
        if (logger.isDebugEnabled()) {
            double delomg = Math.PI * 2 / ((double)nfft * deltat);
            logger.debug((Object)String.format("    omega        tapered\n", new Object[0]));
            logger.debug((Object)String.format("%4ld  %10.3e  %10.3e  %10.3e\n", 0L, 0.0, 0.0, 0.0));
            i = 1;
            while (i < nfreq - 1) {
                double omega = (double)i * delomg;
                logger.debug((Object)String.format("%4ld  %10.3e  %10.3e  %10.3e\n", i, omega, fre[i], fim[i]));
                ++i;
            }
        }
        if (retFD != 0) {
            Fft991.fft991(output, 0, workFFT, 0, pfact[0].trigs, 0, pfact[0].ifax, 0, 1, nfft, nfft, 1, 1);
        }
        pnfft[0] = nfft;
        Transfer.cleanPZ(rs);
        return retval;
    }

    public static int respLen(ResponseStruct rs, double deltat, double[] freq) {
        int ii;
        int i;
        double tpr;
        double f;
        PrepFFT.FACT[] pfact = new PrepFFT.FACT[1];
        double[] fre = new double[513];
        double[] fim = new double[513];
        double[] data = new double[1026];
        double[] work = new double[1025];
        int imax = 0;
        int nf_test = PrepFFT.prepFFT(1024, pfact);
        if (nf_test < 0) {
            return -1;
        }
        if (nf_test != 1024) {
            logger.warn((Object)String.format("respLen fatal error: NFFT_TEST (%d) not factorable by 2, 3, 5\n", 1024));
            return -1;
        }
        int nfreq = nf_test / 2 + 1;
        Transfer.response(nf_test, deltat, rs, fre, fim);
        double delfreq = 1.0 / ((double)nf_test * deltat);
        if (logger.isDebugEnabled()) {
            double delomg = Math.PI * 2 / ((double)nf_test * deltat);
            logger.debug((Object)String.format("\nTest response function in Frequency Domain\n", new Object[0]));
            logger.debug((Object)String.format("  i      omega             raw                   tapered\n", new Object[0]));
            f = 0.0;
            tpr = Transfer.ftaper(f, freq[1], freq[0]);
            data[0] = fre[0] * tpr;
            data[1] = 0.0;
            double omega = 0.001 * delomg;
            logger.debug((Object)String.format("%4ld  %10.3e  %10.3e  %10.3e  %10.3e  %10.3e\n", 0L, omega, fre[0], 0.0, data[0], 0.0));
            i = 1;
            while (i < nfreq - 1) {
                ii = i + i;
                f = (double)i * delfreq;
                tpr = Transfer.ftaper(f, freq[1], freq[0]) * Transfer.ftaper(f, freq[2], freq[3]);
                data[ii] = fre[i] * tpr;
                data[ii + 1] = fim[i] * tpr;
                omega = (double)i * delomg;
                logger.debug((Object)String.format("%4ld  %10.3e  %10.3e  %10.3e  %10.3e  %10.3e\n", i, omega, fre[i], fim[i], data[ii], data[ii + 1]));
                ++i;
            }
            data[nf_test] = 0.0;
            data[nf_test + 1] = 0.0;
        } else {
            f = 0.0;
            tpr = Transfer.ftaper(f, freq[1], freq[0]);
            data[0] = fre[0] * tpr;
            data[1] = 0.0;
            i = 1;
            while (i < nfreq - 1) {
                ii = i + i;
                f = (double)i * delfreq;
                tpr = Transfer.ftaper(f, freq[1], freq[0]) * Transfer.ftaper(f, freq[2], freq[3]);
                data[ii] = fre[i] * tpr;
                data[ii + 1] = fim[i] * tpr;
                ++i;
            }
            data[nf_test] = 0.0;
            data[nf_test + 1] = 0.0;
        }
        Fft991.fft991(data, 0, work, 0, pfact[0].trigs, 0, pfact[0].ifax, 0, 1, nf_test, nf_test, 1, 1);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("\nTest response function in TD\n", new Object[0]));
            i = 0;
            while (i < nf_test) {
                logger.debug((Object)String.format("%5ld  %10.3e\n", i, data[i]));
                ++i;
            }
        }
        double imp_max = 0.0;
        i = 0;
        while (i < nf_test) {
            if (Math.abs(data[i]) > imp_max) {
                imp_max = Math.abs(data[i]);
                imax = i;
            }
            ++i;
        }
        if (imp_max > 0.001 * rs.dGain) {
            int left_lim;
            double thresh = imp_max * 0.01;
            int right_lim = left_lim = imax;
            i = imax;
            while (i >= 0) {
                if (Math.abs(data[i]) < thresh) {
                    left_lim = i;
                    break;
                }
                --i;
            }
            if (left_lim == imax) {
                i = nf_test - 1;
                while (i > imax) {
                    if (Math.abs(data[i]) < thresh) {
                        left_lim = i;
                        break;
                    }
                    --i;
                }
                if (left_lim == imax) {
                    return 1024;
                }
            }
            i = imax;
            while (i < nf_test) {
                if (Math.abs(data[i]) < thresh) {
                    right_lim = i;
                    break;
                }
                ++i;
            }
            if (right_lim == imax) {
                i = 0;
                while (i < imax) {
                    if (Math.abs(data[i]) < thresh) {
                        right_lim = i;
                        break;
                    }
                    ++i;
                }
                if (right_lim == imax) {
                    return -1024;
                }
            }
            if (left_lim < right_lim) {
                return right_lim - left_lim + 1;
            }
            return right_lim - left_lim + nf_test + 1;
        }
        return -2;
    }

    public static void pzCancel(ResponseStruct rs, double tol) {
        if (rs.iNumZeros == 0 || rs.iNumPoles == 0) {
            return;
        }
        int ip = 0;
        while (ip < rs.iNumPoles) {
            int mz = -1;
            int iz = 0;
            while (iz < rs.iNumZeros) {
                if (Math.abs(rs.Poles[ip].dReal - rs.Zeros[iz].dReal) < tol && Math.abs(rs.Poles[ip].dImag - rs.Zeros[iz].dImag) < tol) {
                    mz = iz;
                    break;
                }
                ++iz;
            }
            if (mz != -1) {
                int[] ap = new int[]{rs.iNumPoles};
                Transfer.drop(rs.Poles, ap, ip);
                rs.iNumPoles = ap[0];
                int[] az = new int[]{rs.iNumZeros};
                Transfer.drop(rs.Zeros, az, mz);
                rs.iNumZeros = az[0];
                --ip;
                --iz;
            }
            ++ip;
        }
    }

    public static void drop(PZNum[] pPZ, int[] pNumPZ, int ipz) {
        pNumPZ[0] = pNumPZ[0] - 1;
        int i = ipz;
        while (i < pNumPZ[0]) {
            pPZ[i].dReal = pPZ[i + 1].dReal;
            pPZ[i].dImag = pPZ[i + 1].dImag;
            ++i;
        }
    }

    public static void taper(double[] data, int npts, int tLen) {
        if (++tLen < 2 || tLen > npts / 2) {
            return;
        }
        double omega = Math.PI / (double)tLen;
        int i = 1;
        while (i < tLen) {
            int jb = i - 1;
            int je = npts - i;
            double tap = 0.5 * (1.0 - Math.cos(omega * (double)i));
            int n = jb;
            data[n] = data[n] * tap;
            int n2 = je;
            data[n2] = data[n2] * tap;
            ++i;
        }
    }

    public static void deMean(double[] data, int npts, double[] mean) {
        double sum = 0.0;
        if (npts < 1) {
            mean[0] = 0.0;
            return;
        }
        int i = 0;
        while (i < npts) {
            sum += data[i];
            ++i;
        }
        sum /= (double)npts;
        i = 0;
        while (i < npts) {
            int n = i++;
            data[n] = data[n] - sum;
        }
        mean[0] = sum;
    }

    public static void cleanPZ(ResponseStruct pRS) {
        if (pRS.Zeros != null) {
            pRS.Zeros = null;
        }
        if (pRS.Poles != null) {
            pRS.Poles = null;
        }
        pRS.iNumPoles = 0;
        pRS.iNumZeros = 0;
    }

    public static void main0(String[] args) throws IOException {
        ResponseStruct rs = new ResponseStruct();
        String pzFile = "/usr/local/jopens/gm/cfg/BBVS120.pz";
        Transfer.readSacPZ(pzFile, rs);
        System.out.println("nz=" + rs.iNumZeros + ", np=" + rs.iNumPoles);
    }

    public static void main(String[] args) throws IOException {
        SAC sac = new SAC();
        sac.readBinarySAC(new File("TestCase/SimuSac/jpdata/noto/ISK003.KN.z.sac"));
        int lenRaw = sac.NPTS;
        PrepFFT.FACT[] pf = new PrepFFT.FACT[1];
        int nfft = PrepFFT.prepFFT(lenRaw, pf);
        double[] rawData = new double[2 * nfft];
        int i = 0;
        while (i < lenRaw) {
            rawData[i] = sac.data1[i];
            ++i;
        }
        int lenProc = nfft;
        double[] workFFT = new double[2 * lenProc * 1];
        Fft991.fft991(rawData, 0, workFFT, 0, pf[0].trigs, 0, pf[0].ifax, 0, 1, nfft, nfft, 1, -1);
        Fft991.fft991(rawData, 0, workFFT, 0, pf[0].trigs, 0, pf[0].ifax, 0, 1, nfft, nfft, 1, 1);
        double[] r = new double[nfft];
        double sum = 0.0;
        int i2 = 0;
        while (i2 < nfft) {
            r[i2] = Math.abs(rawData[i2] - (double)sac.data1[i2]);
            System.out.printf("%18.16f\n", r[i2]);
            sum += r[i2];
            ++i2;
        }
        System.out.printf("sum=%18.16f\n", sum);
    }

    public static class PZNum {
        public double dReal;
        public double dImag;
    }

    public static class ResponseStruct {
        public double dGain;
        public int iNumPoles;
        public int iNumZeros;
        public PZNum[] Poles;
        public PZNum[] Zeros;
    }
}

