/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.signal.seismograph;

import cn.org.gddsn.signal.seismograph.HiPassFilter;
import cn.org.gddsn.signal.seismograph.SeisFilter;

public class WAFilter
extends SeisFilter {
    private HiPassFilter hp;
    private static final double[] STD_HTG = new double[]{0.7, 0.8, 2080.0};
    private double gainwa = STD_HTG[2];
    private static final double[][] T0 = new double[][]{{0.719, 0.775, 0.775}, {0.307, 0.299, 0.299}, {1.0, 1.0, 1.0}, {3.0, 2.99, 2.99}};
    private static final double[][] H = new double[][]{{0.568, 0.781, 0.781}, {-0.461, -0.0583, -0.0541}, {-0.108, 0.016, 0.018}, {-0.021, 0.044, 0.044}};
    public static final double[][] G = new double[][]{{3110.0, 2963.0, 2963.0}, {0.875, 0.996, 1.0}, {0.988, 0.988, 1.0}, {0.986, 0.999, 1.0}};

    public WAFilter(double srate, double g, double h, double t0, double gwa, String waveType) {
        this.hp = new HiPassFilter(1.0, 0.998);
        this.gainwa = gwa;
        double w0 = Math.PI * 2 / t0;
        double c1 = 1.0 + h * w0 / srate;
        double c2 = 1.0 + 2.0 * h * w0 / srate + w0 / srate * (w0 / srate);
        double[] b = new double[]{gwa / g / srate / c2, -gwa / g / srate / c2};
        if (waveType.equals("A")) {
            b = new double[]{gwa / srate / srate / c2};
        }
        double[] a = new double[]{1.0, -2.0 * c1 / c2, 1.0 / c2};
        this.filter.set(b, a);
        this.filter.setName("WA");
    }

    public double getGainwa() {
        return this.gainwa;
    }

    public double filter(double v) {
        return this.filter.filter(this.hp.filter(v));
    }

    public static SeisFilter buildFilter(String rspType, String chanType, double g) {
        double srate = 100.0;
        int rsp = -1;
        int chan = -1;
        String wave = "V";
        if (rspType.equalsIgnoreCase("WA")) {
            rsp = 0;
        } else if (rspType.equalsIgnoreCase("RST03")) {
            rsp = 1;
        } else if (rspType.equalsIgnoreCase("RST10")) {
            rsp = 2;
        } else if (rspType.equalsIgnoreCase("RST30")) {
            rsp = 3;
        }
        if (chanType.equalsIgnoreCase("VBB")) {
            srate = 20.0;
            chan = 0;
        } else if (chanType.equalsIgnoreCase("VSP")) {
            srate = 100.0;
            chan = 1;
        } else if (chanType.equalsIgnoreCase("LG")) {
            srate = 100.0;
            chan = 2;
            wave = "A";
        }
        if (rsp == -1 || chan == -1) {
            return null;
        }
        return new WAFilter(srate, g, H[rsp][chan], T0[rsp][chan], G[rsp][chan], wave);
    }

    public static SeisFilter buildDefaultWA(double srate, double g, String waveType) {
        return new WAFilter(srate, g, STD_HTG[0], STD_HTG[1], STD_HTG[2], waveType);
    }
}

