/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.sms;

import cn.org.gddsn.liss.client.LissClient;
import cn.org.gddsn.liss.port.SerialParameters;
import cn.org.gddsn.sms.SendByModem;
import cn.org.gddsn.util.Log4jConfig;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import javax.comm.CommPortIdentifier;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.SerialPort;
import javax.comm.UnsupportedCommOperationException;
import org.apache.log4j.Logger;
import org.springframework.context.support.FileSystemXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSSAlarm
implements Runnable {
    static Logger logger = Logger.getLogger(SSSAlarm.class);
    String sound_port = "/dev/cuaU0";
    byte cancelAlarm = (byte)8;
    byte[] sound_msg = new byte[]{7, 7, 7, 7, 7, 49};
    int sound_type = 13;
    private LissClient client = null;
    private int timeout = 3;
    private int alarmStationCount = 3;
    private List<String> monStation;
    private Hashtable<String, Integer> status;
    private SendByModem sendMessage;
    public String[] phoneNumber;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        logger.info((Object)"SSS Alarm thread start...");
        int bad_cnt = 0;
        while (true) {
            try {
                this.client.init();
            }
            catch (Exception ex) {
                logger.warn((Object)ex.getMessage(), (Throwable)ex);
                try {
                    Thread.sleep(300000L);
                }
                catch (Exception exception) {}
                continue;
            }
            try {
                while (true) {
                    String name;
                    bad_cnt = 0;
                    this.status = new Hashtable();
                    for (String n : this.monStation) {
                        this.status.put(n, 0);
                    }
                    int j = 0;
                    while (j < this.timeout * 60 / 30) {
                        String msg = this.client.stat_monitor();
                        StringTokenizer st = new StringTokenizer(msg);
                        int size = st.countTokens() / 2 - 1;
                        name = st.nextToken();
                        int i = 0;
                        while (i < size) {
                            name = st.nextToken();
                            String stat = st.nextToken();
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("sta: " + name + "/stat=" + stat));
                            }
                            if (this.monStation.contains(name) && this.status.get(name) != null) {
                                int value = this.status.get(name) + Integer.parseInt(stat);
                                this.status.remove(name);
                                this.status.put(name, value);
                            }
                            ++i;
                        }
                        ++j;
                    }
                    String message = "In " + this.timeout + " min, broken link station: ";
                    Enumeration<String> enu = this.status.keys();
                    while (enu.hasMoreElements()) {
                        name = enu.nextElement();
                        if (this.status.get(name) != 0) continue;
                        message = String.valueOf(message) + name + " ";
                        ++bad_cnt;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.info((Object)("bad station number: " + bad_cnt));
                        logger.info((Object)message);
                    }
                    if (bad_cnt < this.alarmStationCount) continue;
                    logger.warn((Object)("bad station number: " + bad_cnt));
                    logger.warn((Object)message);
                    try {
                        this.doBPCall(message);
                    }
                    catch (Exception ex) {
                        logger.warn((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
            }
            catch (Exception ex) {
                logger.warn((Object)ex.getMessage(), (Throwable)ex);
                try {
                    Thread.sleep(300000L);
                }
                catch (Exception exception) {
                    continue;
                }
            }
            break;
        }
    }

    void doBPCall(String message) {
        this.sendMessage.send(this.phoneNumber, message);
    }

    void doSoundAlarm() throws Exception {
        SerialPort sPort;
        CommPortIdentifier portId;
        SerialParameters sp = new SerialParameters();
        sp.setPortName(this.sound_port);
        sp.setBaudRate(4800);
        try {
            portId = CommPortIdentifier.getPortIdentifier((String)sp.getPortName());
        }
        catch (NoSuchPortException e) {
            throw new Exception(e.getMessage());
        }
        try {
            sPort = (SerialPort)portId.open("IPServerAlarm", 3000);
        }
        catch (PortInUseException e) {
            throw new Exception(e.getMessage());
        }
        try {
            sPort.setSerialPortParams(4800, 8, 1, 0);
        }
        catch (UnsupportedCommOperationException e) {
            // empty catch block
        }
        try {
            OutputStream os = sPort.getOutputStream();
            os.write(this.cancelAlarm);
            os.flush();
            os.write(this.sound_msg);
            os.flush();
            os.close();
            sPort.close();
        }
        catch (IOException e) {
            sPort.close();
            throw new Exception("Error opening I/O streams");
        }
    }

    public SendByModem getSendMessage() {
        return this.sendMessage;
    }

    public void setSendMessage(SendByModem sendMessage) {
        this.sendMessage = sendMessage;
    }

    public int getAlarmStationCount() {
        return this.alarmStationCount;
    }

    public void setAlarmStationCount(int alarmStationCount) {
        this.alarmStationCount = alarmStationCount;
    }

    public LissClient getClient() {
        return this.client;
    }

    public void setClient(LissClient client) {
        this.client = client;
    }

    public List<String> getMonStation() {
        return this.monStation;
    }

    public void setMonStation(List<String> monStation) {
        this.monStation = monStation;
        this.status = new Hashtable();
        for (String name : monStation) {
            logger.info((Object)name);
            this.status.put(name, 0);
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
        if (timeout < 1) {
            this.timeout = 1;
        }
    }

    public void setPhoneNumber(String[] phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public static void main(String[] args) {
        Log4jConfig.loadForMain((String)"SSSAlarm.properties");
        FileSystemXmlApplicationContext ctx = new FileSystemXmlApplicationContext(new String[]{"SSSAlarm.xml"});
        SSSAlarm sssAlarm = (SSSAlarm)ctx.getBean("sssAlarm");
        new Thread(sssAlarm).start();
    }
}

