(ns krypton.pki
  (:require [clojure.java.io :refer :all])
  (:import [ec.rubrica.keystore Pkcs12FileKeyStoreProvider]
           [ec.rubrica.keystore KeyStoreUtilities]))

(java.security.Security/addProvider
 (org.bouncycastle.jce.provider.BouncyCastleProvider.))

(defn load-keystore
  [f password]
  (.getKeystore
   (new
    Pkcs12FileKeyStoreProvider
    (as-file
     f))
   (char-array password)))

(defn private-key
  [ks password]
  (.getKey
   ks
   (.getAlias
    (first 
     (KeyStoreUtilities/getSigningAliases ks)))
   (char-array password)))

(defn public-key
  [ks]
  (.getPublicKey
   (.getCertificate
    ks
    (.getAlias
     (first
      (KeyStoreUtilities/getSigningAliases
       ks))))))

(defn generate-keys []
  (let [generator (doto (java.security.KeyPairGenerator/getInstance "RSA" "BC")
                    (.initialize 1024))]
    (.generateKeyPair generator)))

(defn encrypt [bytes public-key]
  (let [cipher (doto (javax.crypto.Cipher/getInstance "RSA/ECB/PKCS1Padding" "BC")
                 (.init javax.crypto.Cipher/ENCRYPT_MODE public-key))]
    (.doFinal cipher bytes)))


(defn decrypt [bytes private-key]
  (let [cipher (doto (javax.crypto.Cipher/getInstance "RSA/ECB/PKCS1Padding" "BC")
                 (.init javax.crypto.Cipher/DECRYPT_MODE private-key))]
    (.doFinal cipher bytes)))

(defn sign [data private-key]
  (let [sig (doto (java.security.Signature/getInstance "SHA1withRSA" "BC")
              (.initSign private-key (java.security.SecureRandom.))
              (.update data))]
    (.sign sig)))

(defn verify [signuture data public-key]
  (let [sig (doto (java.security.Signature/getInstance "SHA1withRSA" "BC")
              (.initVerify public-key)
              (.update data))]
    (.verify sig signuture)))


