/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.json;

import com.amazon.speech.speechlet.Session;
import com.amazon.speech.speechlet.SpeechletRequest;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;

public class SpeechletRequestEnvelope {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final String version;
    private final Session session;
    private final SpeechletRequest request;

    public static Builder builder() {
        return new Builder();
    }

    private SpeechletRequestEnvelope(Builder builder) {
        this.version = builder.version;
        this.session = builder.session;
        this.request = builder.request;
    }

    private SpeechletRequestEnvelope(@JsonProperty(value="version") String version, @JsonProperty(value="session") Session session, @JsonProperty(value="request") SpeechletRequest request) {
        this.version = version;
        this.session = session;
        this.request = request;
    }

    public String getVersion() {
        return this.version;
    }

    public Session getSession() {
        return this.session;
    }

    public SpeechletRequest getRequest() {
        return this.request;
    }

    public static SpeechletRequestEnvelope fromJson(InputStream in) throws IOException {
        return (SpeechletRequestEnvelope)OBJECT_MAPPER.readValue(in, SpeechletRequestEnvelope.class);
    }

    public static SpeechletRequestEnvelope fromJson(byte[] json) throws IOException {
        return (SpeechletRequestEnvelope)OBJECT_MAPPER.readValue(json, SpeechletRequestEnvelope.class);
    }

    public static SpeechletRequestEnvelope fromJson(String json) throws IOException {
        return (SpeechletRequestEnvelope)OBJECT_MAPPER.readValue(json, SpeechletRequestEnvelope.class);
    }

    static {
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
    }

    public static final class Builder {
        private String version = "1.0";
        private Session session;
        private SpeechletRequest request;

        private Builder() {
        }

        public Builder withVersion(String version) {
            this.version = version;
            return this;
        }

        public Builder withSession(Session session) {
            this.session = session;
            return this;
        }

        public Builder withRequest(SpeechletRequest request) {
            this.request = request;
            return this;
        }

        public SpeechletRequestEnvelope build() {
            return new SpeechletRequestEnvelope(this);
        }
    }
}

