/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet;

import com.amazon.speech.slu.Intent;
import com.amazon.speech.speechlet.SpeechletRequest;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Date;
import org.apache.commons.lang3.Validate;

@JsonTypeName(value="IntentRequest")
public class IntentRequest
extends SpeechletRequest {
    private final Intent intent;

    public static Builder builder() {
        return new Builder();
    }

    private IntentRequest(Builder builder) {
        super(builder.requestId, builder.timestamp);
        this.intent = builder.intent;
    }

    protected IntentRequest(@JsonProperty(value="requestId") String requestId, @JsonProperty(value="timestamp") Date timestamp, @JsonProperty(value="intent") Intent intent) {
        super(requestId, timestamp);
        this.intent = intent;
    }

    public Intent getIntent() {
        return this.intent;
    }

    public static final class Builder {
        private String requestId;
        private Date timestamp = new Date();
        private Intent intent;

        private Builder() {
        }

        public Builder withRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public Builder withTimestamp(Date timestamp) {
            this.timestamp = timestamp != null ? new Date(timestamp.getTime()) : null;
            return this;
        }

        public Builder withIntent(Intent intent) {
            this.intent = intent;
            return this;
        }

        public IntentRequest build() {
            Validate.notBlank((CharSequence)this.requestId, (String)"RequestId must be defined", (Object[])new Object[0]);
            return new IntentRequest(this);
        }
    }
}

