/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet;

import com.amazon.speech.speechlet.SpeechletRequest;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Date;
import org.apache.commons.lang3.Validate;

@JsonTypeName(value="LaunchRequest")
public class LaunchRequest
extends SpeechletRequest {
    public static Builder builder() {
        return new Builder();
    }

    private LaunchRequest(Builder builder) {
        super(builder.requestId, builder.timestamp);
    }

    private LaunchRequest(@JsonProperty(value="requestId") String requestId, @JsonProperty(value="timestamp") Date timestamp) {
        super(requestId, timestamp);
    }

    public static final class Builder {
        private String requestId;
        private Date timestamp = new Date();

        private Builder() {
        }

        public Builder withRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public Builder withTimestamp(Date timestamp) {
            this.timestamp = timestamp != null ? new Date(timestamp.getTime()) : null;
            return this;
        }

        public LaunchRequest build() {
            Validate.notBlank((CharSequence)this.requestId, (String)"RequestId must be defined", (Object[])new Object[0]);
            return new LaunchRequest(this);
        }
    }
}

