/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet;

import com.amazon.speech.speechlet.SpeechletRequest;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Date;
import org.apache.commons.lang3.Validate;

@JsonTypeName(value="SessionEndedRequest")
public final class SessionEndedRequest
extends SpeechletRequest {
    private final Reason reason;

    public static Builder builder() {
        return new Builder();
    }

    private SessionEndedRequest(Builder builder) {
        super(builder.requestId, builder.timestamp);
        this.reason = builder.reason;
    }

    private SessionEndedRequest(@JsonProperty(value="requestId") String requestId, @JsonProperty(value="timestamp") Date timestamp, @JsonProperty(value="reason") Reason reason) {
        super(requestId, timestamp);
        this.reason = reason;
    }

    public Reason getReason() {
        return this.reason;
    }

    public static final class Builder {
        private String requestId;
        private Date timestamp = new Date();
        private Reason reason;

        private Builder() {
        }

        public Builder withRequestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public Builder withTimestamp(Date timestamp) {
            this.timestamp = timestamp != null ? new Date(timestamp.getTime()) : null;
            return this;
        }

        public Builder withReason(Reason reason) {
            this.reason = reason;
            return this;
        }

        public SessionEndedRequest build() {
            Validate.notBlank((CharSequence)this.requestId, (String)"RequestId must be defined", (Object[])new Object[0]);
            return new SessionEndedRequest(this);
        }
    }

    public static enum Reason {
        USER_INITIATED,
        ERROR,
        EXCEEDED_MAX_REPROMPTS;

    }
}

