/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet;

import com.amazon.speech.json.SpeechletRequestEnvelope;
import com.amazon.speech.json.SpeechletResponseEnvelope;
import com.amazon.speech.speechlet.IntentRequest;
import com.amazon.speech.speechlet.LaunchRequest;
import com.amazon.speech.speechlet.Session;
import com.amazon.speech.speechlet.SessionEndedRequest;
import com.amazon.speech.speechlet.SessionStartedRequest;
import com.amazon.speech.speechlet.Speechlet;
import com.amazon.speech.speechlet.SpeechletException;
import com.amazon.speech.speechlet.SpeechletRequest;
import com.amazon.speech.speechlet.SpeechletRequestHandlerException;
import com.amazon.speech.speechlet.SpeechletResponse;
import java.io.IOException;

public class SpeechletRequestDispatcher {
    private final Speechlet speechlet;

    public SpeechletRequestDispatcher(Speechlet speechlet) {
        this.speechlet = speechlet;
    }

    public SpeechletResponseEnvelope dispatchSpeechletCall(SpeechletRequestEnvelope requestEnvelope, Session session) throws IOException, SpeechletRequestHandlerException, SpeechletException {
        SpeechletResponse speechletResponse;
        String requestId;
        boolean saveSessionAttributes = true;
        SpeechletRequest speechletRequest = requestEnvelope.getRequest();
        SpeechletResponseEnvelope responseEnvelope = new SpeechletResponseEnvelope();
        responseEnvelope.setVersion("1.0");
        String string = requestId = speechletRequest != null ? speechletRequest.getRequestId() : null;
        if (session != null && session.isNew()) {
            SessionStartedRequest sessionStartedRequest = SessionStartedRequest.builder().withRequestId(requestId).build();
            this.speechlet.onSessionStarted(sessionStartedRequest, session);
        }
        if (speechletRequest instanceof IntentRequest) {
            speechletResponse = this.speechlet.onIntent((IntentRequest)speechletRequest, session);
            responseEnvelope.setResponse(speechletResponse);
            if (speechletResponse != null) {
                saveSessionAttributes = !speechletResponse.getShouldEndSession();
            }
        } else if (speechletRequest instanceof LaunchRequest) {
            speechletResponse = this.speechlet.onLaunch((LaunchRequest)speechletRequest, session);
            responseEnvelope.setResponse(speechletResponse);
            if (speechletResponse != null) {
                saveSessionAttributes = !speechletResponse.getShouldEndSession();
            }
        } else if (speechletRequest instanceof SessionEndedRequest) {
            saveSessionAttributes = false;
            this.speechlet.onSessionEnded((SessionEndedRequest)speechletRequest, session);
        } else {
            String requestType = speechletRequest != null ? speechletRequest.getClass().getName() : null;
            String message = String.format("Unsupported request type %s. Consider updating your SDK version. Request envelope version %s, SDK version %s", requestType, requestEnvelope.getVersion(), "1.0");
            throw new SpeechletRequestHandlerException(message);
        }
        if (session != null && saveSessionAttributes) {
            responseEnvelope.setSessionAttributes(session.getAttributes());
        }
        return responseEnvelope;
    }
}

