/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet;

import com.amazon.speech.json.SpeechletRequestEnvelope;
import com.amazon.speech.json.SpeechletResponseEnvelope;
import com.amazon.speech.speechlet.Session;
import com.amazon.speech.speechlet.Speechlet;
import com.amazon.speech.speechlet.SpeechletException;
import com.amazon.speech.speechlet.SpeechletRequest;
import com.amazon.speech.speechlet.SpeechletRequestDispatcher;
import com.amazon.speech.speechlet.SpeechletRequestHandlerException;
import com.amazon.speech.speechlet.verifier.SpeechletRequestVerifier;
import com.amazon.speech.speechlet.verifier.SpeechletResponseVerifier;
import java.io.IOException;
import java.util.List;

public class SpeechletRequestHandler {
    private final List<SpeechletRequestVerifier> requestVerifiers;
    private final List<SpeechletResponseVerifier> responseVerifiers;

    public SpeechletRequestHandler(List<SpeechletRequestVerifier> requestVerifiers, List<SpeechletResponseVerifier> responseVerifiers) {
        this.requestVerifiers = requestVerifiers;
        this.responseVerifiers = responseVerifiers;
    }

    public byte[] handleSpeechletCall(Speechlet speechlet, byte[] serializedSpeechletRequest) throws IOException, SpeechletRequestHandlerException, SpeechletException {
        SpeechletRequestEnvelope requestEnvelope = SpeechletRequestEnvelope.fromJson(serializedSpeechletRequest);
        SpeechletRequest request = requestEnvelope.getRequest();
        Session session = requestEnvelope.getSession();
        for (SpeechletRequestVerifier verifier : this.requestVerifiers) {
            if (verifier.verify(request, session)) continue;
            String message = String.format("Could not validate SpeechletRequest %s using verifier %s, rejecting request", request != null ? request.getRequestId() : "null", verifier.getClass().getSimpleName());
            throw new SpeechletRequestHandlerException(message);
        }
        SpeechletRequestDispatcher dispatcher = new SpeechletRequestDispatcher(speechlet);
        SpeechletResponseEnvelope responseEnvelope = dispatcher.dispatchSpeechletCall(requestEnvelope, session);
        for (SpeechletResponseVerifier verifier : this.responseVerifiers) {
            if (verifier.verify(responseEnvelope, session)) continue;
            String message = String.format("Could not validate SpeechletResponse %s using verifier %s, rejecting response", request.getRequestId(), verifier.getClass().getSimpleName());
            throw new SpeechletRequestHandlerException(message);
        }
        return responseEnvelope.toJsonBytes();
    }
}

