/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet.lambda;

import com.amazon.speech.speechlet.Speechlet;
import com.amazon.speech.speechlet.SpeechletException;
import com.amazon.speech.speechlet.SpeechletRequestHandler;
import com.amazon.speech.speechlet.SpeechletRequestHandlerException;
import com.amazon.speech.speechlet.verifier.ApplicationIdSpeechletRequestVerifier;
import com.amazon.speech.speechlet.verifier.CardSpeechletResponseVerifier;
import com.amazon.speech.speechlet.verifier.OutputSpeechSpeechletResponseVerifier;
import com.amazon.speech.speechlet.verifier.ResponseSizeSpeechletResponseVerifier;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Set;
import org.apache.commons.io.IOUtils;

public abstract class SpeechletRequestStreamHandler
implements RequestStreamHandler {
    private final Speechlet speechlet;
    private final SpeechletRequestHandler speechletRequestHandler;

    public SpeechletRequestStreamHandler(Speechlet speechlet, Set<String> supportedApplicationIds) {
        this.speechlet = speechlet;
        this.speechletRequestHandler = new SpeechletRequestHandler(Arrays.asList(new ApplicationIdSpeechletRequestVerifier(supportedApplicationIds)), Arrays.asList(new ResponseSizeSpeechletResponseVerifier(), new OutputSpeechSpeechletResponseVerifier(), new CardSpeechletResponseVerifier()));
    }

    public final void handleRequest(InputStream input, OutputStream output, Context context) throws IOException {
        byte[] outputBytes;
        byte[] serializedSpeechletRequest = IOUtils.toByteArray((InputStream)input);
        try {
            outputBytes = this.speechletRequestHandler.handleSpeechletCall(this.speechlet, serializedSpeechletRequest);
        }
        catch (SpeechletException | SpeechletRequestHandlerException ex) {
            throw new RuntimeException(ex);
        }
        output.write(outputBytes);
    }
}

