/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet.servlet;

import com.amazon.speech.speechlet.Speechlet;
import com.amazon.speech.speechlet.SpeechletRequestHandler;
import com.amazon.speech.speechlet.SpeechletRequestHandlerException;
import com.amazon.speech.speechlet.authentication.SpeechletRequestSignatureVerifier;
import com.amazon.speech.speechlet.verifier.ApplicationIdSpeechletRequestVerifier;
import com.amazon.speech.speechlet.verifier.CardSpeechletResponseVerifier;
import com.amazon.speech.speechlet.verifier.OutputSpeechSpeechletResponseVerifier;
import com.amazon.speech.speechlet.verifier.ResponseSizeSpeechletResponseVerifier;
import com.amazon.speech.speechlet.verifier.SpeechletRequestVerifier;
import com.amazon.speech.speechlet.verifier.TimestampSpeechletRequestVerifier;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeechletServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(SpeechletServlet.class);
    private static final long serialVersionUID = 3257254794185762002L;
    private transient Speechlet speechlet;
    private final transient SpeechletRequestHandler speechletRequestHandler;
    private final boolean disableRequestSignatureCheck = Boolean.parseBoolean(System.getProperty("com.amazon.speech.speechlet.servlet.disableRequestSignatureCheck"));

    public SpeechletServlet() {
        ArrayList<SpeechletRequestVerifier> requestVerifiers = new ArrayList<SpeechletRequestVerifier>();
        requestVerifiers.add(this.getApplicationIdVerifier());
        TimestampSpeechletRequestVerifier timestampVerifier = this.getTimetampVerifier();
        if (timestampVerifier != null) {
            requestVerifiers.add(timestampVerifier);
        }
        this.speechletRequestHandler = new SpeechletRequestHandler(requestVerifiers, Arrays.asList(new ResponseSizeSpeechletResponseVerifier(), new OutputSpeechSpeechletResponseVerifier(), new CardSpeechletResponseVerifier()));
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        byte[] serializedSpeechletRequest = IOUtils.toByteArray((InputStream)request.getInputStream());
        byte[] outputBytes = null;
        try {
            if (this.disableRequestSignatureCheck) {
                log.warn("Warning: Speechlet request signature verification has been disabled!");
            } else {
                SpeechletRequestSignatureVerifier.checkRequestSignature(serializedSpeechletRequest, request.getHeader("Signature"), request.getHeader("SignatureCertChainUrl"));
            }
            outputBytes = this.speechletRequestHandler.handleSpeechletCall(this.speechlet, serializedSpeechletRequest);
        }
        catch (SpeechletRequestHandlerException | SecurityException ex) {
            int statusCode = 400;
            log.error("Exception occurred in doPost, returning status code {}", (Object)statusCode, (Object)ex);
            response.sendError(statusCode, ex.getMessage());
            return;
        }
        catch (Exception ex) {
            int statusCode = 500;
            log.error("Exception occurred in doPost, returning status code {}", (Object)statusCode, (Object)ex);
            response.sendError(statusCode, ex.getMessage());
            return;
        }
        response.setContentType("application/json");
        response.setStatus(200);
        try (ServletOutputStream out = response.getOutputStream();){
            response.setContentLength(outputBytes.length);
            out.write(outputBytes);
        }
    }

    public Speechlet getSpeechlet() {
        return this.speechlet;
    }

    public void setSpeechlet(Speechlet speechlet) {
        this.speechlet = speechlet;
    }

    private ApplicationIdSpeechletRequestVerifier getApplicationIdVerifier() {
        Set<String> supportedApplicationIds = Collections.emptySet();
        String commaDelimitedListOfSupportedApplicationIds = System.getProperty("com.amazon.speech.speechlet.servlet.supportedApplicationIds");
        if (!StringUtils.isBlank((CharSequence)commaDelimitedListOfSupportedApplicationIds)) {
            supportedApplicationIds = new HashSet<String>(Arrays.asList(commaDelimitedListOfSupportedApplicationIds.split(",")));
        }
        return new ApplicationIdSpeechletRequestVerifier(supportedApplicationIds);
    }

    private TimestampSpeechletRequestVerifier getTimetampVerifier() {
        String timestampToleranceAsString = System.getProperty("com.amazon.speech.speechlet.servlet.timestampTolerance");
        if (!StringUtils.isBlank((CharSequence)timestampToleranceAsString)) {
            try {
                long timestampTolerance = Long.parseLong(timestampToleranceAsString);
                return new TimestampSpeechletRequestVerifier(timestampTolerance, TimeUnit.SECONDS);
            }
            catch (NumberFormatException ex) {
                log.warn("The configured timestamp tolerance {} is invalid, disabling timestamp verification", (Object)timestampToleranceAsString);
            }
        } else {
            log.warn("No timestamp tolerance has been configured, disabling timestamp verification");
        }
        return null;
    }
}

