/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet.verifier;

import com.amazon.speech.speechlet.Session;
import com.amazon.speech.speechlet.SpeechletRequest;
import com.amazon.speech.speechlet.verifier.SpeechletRequestVerifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationIdSpeechletRequestVerifier
implements SpeechletRequestVerifier {
    private final Set<String> supportedApplicationIds;
    private static final Logger log = LoggerFactory.getLogger(ApplicationIdSpeechletRequestVerifier.class);

    public ApplicationIdSpeechletRequestVerifier(Set<String> supportedApplicationIds) {
        this.supportedApplicationIds = Collections.unmodifiableSet(new HashSet<String>(supportedApplicationIds));
    }

    @Override
    public boolean verify(SpeechletRequest request, Session session) {
        if (this.supportedApplicationIds.isEmpty()) {
            log.warn("Application ID verification has been disabled, allowing request for all application IDs");
            return true;
        }
        if (session == null || session.getApplication() == null || session.getApplication().getApplicationId() == null) {
            return false;
        }
        return this.supportedApplicationIds.contains(session.getApplication().getApplicationId());
    }
}

