/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.speech.speechlet.verifier;

import com.amazon.speech.json.SpeechletResponseEnvelope;
import com.amazon.speech.speechlet.Session;
import com.amazon.speech.speechlet.verifier.SpeechletResponseVerifier;
import com.amazon.speech.ui.Card;
import com.amazon.speech.ui.SimpleCard;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardSpeechletResponseVerifier
implements SpeechletResponseVerifier {
    private static final Logger log = LoggerFactory.getLogger(CardSpeechletResponseVerifier.class);
    private static final int MAX_CARD_SIZE = 8000;

    @Override
    public boolean verify(SpeechletResponseEnvelope responseEnvelope, Session session) {
        SimpleCard simpleCard;
        int cardSize;
        if (responseEnvelope == null || responseEnvelope.getResponse() == null) {
            return true;
        }
        Card card = responseEnvelope.getResponse().getCard();
        if (card instanceof SimpleCard && (cardSize = StringUtils.length((CharSequence)(simpleCard = (SimpleCard)card).getContent()) + StringUtils.length((CharSequence)simpleCard.getTitle())) > 8000) {
            log.warn("Card with size {} exceeds the maximum allowed size of {} and will be rejected by the Alexa service", (Object)cardSize, (Object)8000);
        }
        return true;
    }
}

