;; Copyright (c) Krešimir Šojat, 2010. All rights reserved. The use
;; and distribution terms for this software are covered by the Eclipse
;; Public License 1.0 (http://opensource.org/licenses/eclipse-1.0.php)
;; which can be found in the file epl-v10.html at the root of this
;; distribution. By using this software in any fashion, you are
;; agreeing to be bound by the terms of this license. You must not
;; remove this notice, or any other, from this software.

(ns
  #^{:author "Krešimir Šojat"
     :license {:name "Eclipse Public License 1.0"
               :url  "http://opensource.org/licenses/eclipse-1.0.php"}}
  eciton.log
  (:require [yummy.log :as log]
            [eciton.core :as ant])
  (:import (org.apache.tools.ant Project)))

(defn logp [p msg]
  (condp = p
    Project/MSG_ERR     (log/error msg)
    Project/MSG_WARN    (log/warn  msg)
    Project/MSG_INFO    (log/info  msg)
    Project/MSG_VERBOSE (log/trace msg)
    Project/MSG_DEBUG   (log/debug msg)))

(defn logger []
  (ant/listener
    :build-started
    (fn [_]
      (log/info "Build started"))

    :build-finished
    (fn [{:keys [exception]}]
      (if exception
        (log/error "Build failed" exception)
        (log/info "Build finished")))

    :target-started
    (fn [{:keys [target priority]}]
      (when target
        (logp priority (str "Executing task: " (.getName target)))))

    :message-logged
    (fn [{:keys [task priority message exception]}]
      (let [tname (when task (.getTaskName task))]
        (logp priority
              (str (when tname
                     (format "[%s] " tname))
                   message))
        (when exception
          (log/error "Exception thrown" exception))))))
