(ns com.edocu.help.cache.clojure
  (:require [clojure.core.cache :as cache]
            [com.stuartsierra.component :as component]))

(defrecord AtomCache [c factory]
  component/Lifecycle
  (start [this]
    (assoc this :c (atom (factory))))
  (stop [this]
    (dissoc this :c))
  cache/CacheProtocol
  (lookup [this e]
    (cache/lookup @c e))
  (lookup [this e not-found]
    (cache/lookup @c e not-found))
  (has? [this e]
    (cache/has? @c e))
  (hit [this e]
    (swap!
      c
      cache/hit
      e))
  (miss [this e ret]
    (swap!
      c
      cache/miss
      e
      ret))
  (evict [this e]
    (swap!
      c
      cache/evict
      e))
  (seed [this base]
    (swap!
      c
      cache/seed
      base)))

(defn ->atom-cache
  "Return component with cache in atom"
  [factory]
  (map->AtomCache {:factory factory}))
