(ns com.edocu.communication.protocols)

(defrecord Message [^String topic body]
  Object
  (toString [this] (pr-str this)))

(defprotocol IMessageManagement
  (route-message! [this ^String topic ^Message message] "Send message to topic")
  (send-message! [this ^String topic ^Message message] "Send message to routing topic for routing it to destination topic"))

(defprotocol ITopicManagement
  (register-topics! [this ^String topics] "Register new topics in router")
  (subscribe-to-topic [this ^String topic callback_chan] "Return IEventStream subscribed to topic"))

(defprotocol IErrorsManagement
  (report-malformed-message! [this message] "Report malformed message to system topic")
  (report-service-error! [this message] "Report service error"))

(defprotocol ICommunicationFactory
  (create->Communicator [this group_name] "Return new commnicator which implement IMessageManagement ITopicManagement IErrorsManagement"))