(ns com.edocu.communication.protocols
  (:require [cheshire.core :as json]))

(defprotocol IMessage
  (parsed-message-body [message] "Return parsed message")
  (message-body [message] "Return raw message body"))

(defrecord Message [^String topic body]
  Object
  (toString [this] (pr-str this))

  IMessage
  (parsed-message-body [_]
    (json/parse-cbor @body true))

  (message-body [_]
    @body))

(defn create->SendMessage [^String topic body]
  (->Message
    topic
    (delay (json/generate-cbor body))))

(defn create->ReceiveMessage [^String topic body]
  (->Message
    topic
    (delay body)))

(defprotocol IMessageManagement
  (route-message! [this ^String topic ^IMessage message] "Send message to topic")
  (send-message! [this ^String topic message] "Send message to routing topic for routing it to destination topic"))

(defprotocol ITopicManagement
  (register-topics! [this ^String topics] "Register new topics in router")
  (subscribe-to-topic [this ^String topic callback_chan] "Return IEventStream subscribed to topic"))

(defprotocol IErrorsManagement
  (report-malformed-message! [this message] "Report malformed message to system topic")
  (report-service-error! [this message] "Report service error"))

(defprotocol ICommunicationFactory
  (create->Communicator [this consumer_config] "Return new commnicator which implement IMessageManagement ITopicManagement IErrorsManagement"))