(ns cljs.com.edocu.log
  (:require
    [clojure.string :as clj-str]
    [cljs.nodejs :as nodejs]))

(defonce winston (nodejs/require "winston"))

(defonce log-lvl (atom nil))

(defonce logger (delay
                  (let [formats (.-format winston)
                        transports (.-transports winston)
                        console (.-Console transports)
                        result (.createLogger winston #js {:level  (or @log-lvl
                                                                       (.-LOG_LVL (.-env nodejs/process))
                                                                       "debug")
                                                           :format (.json formats)})]
                    (.add result (console. #js {}))
                    result)))

(defn log
  [level & message]
  (.log @logger #js {:level level :message (clj-str/join " " message)}))

(defonce info (partial log "info"))
(defonce debug (partial log "debug"))
(defonce error (partial log "error"))

(defn prepare-logger
  "Set log level according to setting from env variable"
  ([]
   (prepare-logger (or (.-LOG_LVL (.-env nodejs/process))
                       "info")))
  ([lvl]
   (reset! log-lvl lvl)
   @logger))
