(ns clj.com.edocu.communication.kafka.config
  (:require [com.edocu.configuration.core :as config]
            [franzy.admin.zookeeper.client :as client]
            [franzy.admin.zookeeper.defaults :as zk-defaults]))

(def is-secure? false)

(defn zk-config []
  (println "Volaju ma!!!!")
  {:servers (config/zookeepers-servers)})

(defn make-zk-config []
  (merge (zk-defaults/zk-client-defaults)) (zk-config))

(defn make-zk-client []
  (client/make-zk-client (make-zk-config)))

(defn make-zk-utils []
  (client/make-zk-utils (make-zk-config) is-secure?))



