(ns com.edocu.configuration.core
  (:require [environ.core :as e]
            [com.edocu.configuration.etcd :as etcd]
            [taoensso.timbre :as timbre]))

(def base-url-promise (promise ))

(defn base-url []
  (if-not (realized? base-url-promise)
    (do
      (deliver base-url-promise
               (etcd/get-config-for
                 "base-url"
                 "https://edocu.service.dev.edocu.local"))
      (timbre/trace "base-url" @base-url-promise)))
  @base-url-promise)

