(ns com.edocu.configuration.etcd
  (:require [etcd-clojure.core :as etcd]
            [environ.core :as e]
            [taoensso.timbre :as timbre]))

(def etcd-url-promise (promise ))

(defn connect! []
  (if-not (realized? etcd-url-promise)
    (do
      (deliver etcd-url-promise
               (or
                 (e/env :etcd-url)
                 "etcd.db.dev.edocu.local"))
      (timbre/trace "connect!" @etcd-url-promise)
      (etcd/connect! @etcd-url-promise)))
  @etcd-url-promise)

(def ^:const ^String CONFIG_KEY_PREFIX "/edocu/config/")

(defn get-config-for [config_key default]
  (try
    (connect! )
    (or (etcd/get (str CONFIG_KEY_PREFIX config_key))
        default)
    (catch Exception e
      (timbre/error "get-config-for, error:" e)
      default)))
