(ns com.edocu.configuration.mongodb
  (:require [com.edocu.configuration.core :refer [mongodb-replicas-uri mongodb-db env]]
            [monger
             [core :as mg]
             [credentials :as mcred]]
            [taoensso.timbre :as timbre]
            [environ.core :as e])
  (:import [com.mongodb MongoOptions]))

(def ^:private db-promise (promise))

(defn- mg-connect-args []
  (let [^MongoOptions opts (mg/mongo-options [:threads-allowed-to-block-for-connection-multiplier 300])]
    (into [(map #(mg/server-address (:uri %) (:port %)) (mongodb-replicas-uri))
           opts]
          (if (and (e/env :mongodb-username)
                   (e/env :mongodb-password))
            [(mcred/create
               (e/env :mongodb-username)
               (mongodb-db)
               (e/env :mongodb-password))]
            []))))

(defn connect! []
  (timbre/trace "MongoDB connect!:" "addresses:" (mongodb-replicas-uri) "database:" (mongodb-db))
  (let [conn (apply mg/connect (mg-connect-args))
        _db (mg/get-db conn (mongodb-db))]
    (deliver db-promise _db)
    @db-promise))

(defn db []
  (if-not (realized? db-promise)
    (connect!)
    @db-promise))

(def ^:private index-setup (atom []))

(defn add-index-to-setup! [setup_fn]
  (swap! index-setup conj setup_fn))

(defn init-indexes []
  (doseq [ind @index-setup]
    (ind))
  (reset! index-setup []))


