(ns cljs.com.edocu.configuration.etcd
  (:require [cljs.nodejs :as nodejs]
            [taoensso.timbre :as timbre]
            [com.edocu.configuration.constants :as const]))

(def node-etcd
  (nodejs/require "node-etcd"))

(def etcd-atom (atom nil))

(defn etcd-url []
  (or
    (.. cljs.nodejs/process
        -env
        -ETCD_URL)
    const/ETCD_DEFAULT_URL))

(defn connect! []
  (when-not @etcd-atom
    (reset! etcd-atom
            (node-etcd. (etcd-url)))
    (timbre/trace "connect!" @etcd-atom))
  @etcd-atom)

(defn get-config-for [config_key]
  (try
    (let [path (str const/CONFIG_KEY_PREFIX config_key)
          etcd_connection (connect!)
          result (.getSync etcd_connection path)]
      (if (.-err result)
        nil
        (.. result
            -body
            -node
            -value)))
    (catch :default e
      (timbre/error "get-config-for, error:" e)
      nil)))
