(ns com.edocu.sentry.core
  (:require [environ.core :as e]
            [raven-clj.core :as raven]
            [raven-clj.interfaces :as interfaces]))

(def sentry-dsn (delay (e/env :sentry-dsn)))

(defn sentry-capture [service release message error]
  (raven/capture @sentry-dsn
                 (-> {:message message
                      :release release
                      :tags {:service service}}
                     (interfaces/stacktrace error))))
