(ns com.edocu.configuration.constants)

(def ^:const ^String ETCD_DEFAULT_URL "etcd.db.dev.edocu.local")
(def ^:const ^String CONFIG_KEY_PREFIX "/edocu/config/")

;; PATHS

(def ^:const ^String BASE_URL_PATH "base-url")
(def ^:const ^String EMAIL_PREFIX "email/")
(def ^:const ^String SMTP_PATH (str EMAIL_PREFIX "smtp"))
(def ^:const ^String NOTIFICATION_EMAIL_PATH (str EMAIL_PREFIX "addresses/notifications"))
(def ^:const ^String KAFKA_PATH "kafka/")
(def ^:const ^String KAFKA_BROKERS_PATH (str KAFKA_PATH "brokers"))
(def ^:const ^String REDIS_CONFIG_PATH "redis/config")
(def ^:const ^String ZOOKEPER_SERVERS_PATH "zookeeper/servers")
(def ^:const ^String CBR_TOPIC_PATH "router/cbr")
(def ^:const ^String REGISTER_TOPIC_PATH "router/topics/register")
(def ^:const ^String SERVICE_ERROR_TOPIC_PATH "router/topics/service-error")
(def ^:const ^String MALFORMED_MESSAGE_TOPIC_PATH "router/topics/malformed-message")
(def ^:const ^String MONGODB_REPLICAS_URI_PATH "persistence/mongodb/replicas-uri")
(def ^:const ^String MONGODB_DB_PATH "persistence/mongodb/db")
(def ^:const ^String INTEGRATION_ENV_PATH "integration/env")

;; ############################################################################################

;; DEFAULTS

(def ^:const ^String REDIS_HOST "redis.db.dev.edocu.local")
(def ^:const ^String BASE_URL_DEFAULT "https://edocu.service.dev.edocu.local")
(def ^:const ^String SMTP_DEFAULT "")
(def ^:const ^String NOTIFICATION_EMAIL_DEFAULT "notifications@edocu.eu")
(def ^:const ^String ZOOKEPER_SERVERS_DEFAULT ["zookeeper.service.dev.edocu.local:2181"])
(def ^:const ^String KAFKA_BROKERS_DEFAULT ["kafka.mq.dev.edocu.local:9092"])
(def ^:const KAFKA_ZOOKEEPER_DEFAULT {:servers ZOOKEPER_SERVERS_DEFAULT})
(def ^:const ^String CBR_TOPIC_DEFAULT "system.router")
(def ^:const ^String REGISTER_TOPIC_DEFAULT "system.router.register-topic")
(def ^:const ^String SERVICE_ERROR_TOPIC_DEFAULT "system.errors.service")
(def ^:const ^String MALFORMED_MESSAGE_TOPIC_DEFAULT "system.errors.message.malformed")
(def ^:const ^String INTEGRATION_ENV "no")