(ns com.edocu.configuration.etcd
  (:require [taoensso.timbre :as timbre]
            [com.edocu.configuration.constants :as const]
            [etcd-clojure.core :as etcd]
            [environ.core :as e]))

(def etcd-atom (atom nil))

(defn- etcd-url []
  (or
    (e/env :etcd-url)
    const/ETCD_DEFAULT_URL))

(defn connect! []
  (when-not @etcd-atom
    (reset! etcd-atom
            (etcd-url))
    (etcd/connect! @etcd-atom)
    (timbre/trace "connect!" @etcd-atom))
  @etcd-atom)

(defn get-config-for [config_key]
  (try
    (connect!)
    (let [path (str const/CONFIG_KEY_PREFIX config_key)]
      (etcd/get path))
    (catch Exception e
      (timbre/error "get-config-for, error:" e)
      nil)))
