(ns com.edocu.configuration.etcd
  (:require [clojure.tools.logging :as log]
            [com.edocu.configuration.constants :as const]
            [etcd-clojure.core :as etcd]
            [environ.core :as e]))

(defn- etcd-url []
  (or
    (e/env :etcd-url)
    const/ETCD_DEFAULT_URL))

(def etcd-delay (delay
                  (etcd/connect! (etcd-url))
                  (log/trace "connect!" (etcd-url))))

(defn connect! []
  @etcd-delay)

(defn get-config-for [config_key]
  (try
    (connect!)
    (let [path (str const/CONFIG_KEY_PREFIX config_key)]
      (etcd/get path))
    (catch Exception e
      (log/error "get-config-for, error:" e)
      nil)))
