(ns com.edocu.help.memo
  (:require [clojure.core.async :refer [chan go >! <!]]))

(defn init-memo-storage [this]
  (with-meta this {:memo (atom {})}))

(defmacro with-memo [this k original_fn]
  `(let [result# (chan )]
     (go
       (if-let [in_memo# (get @(:memo (meta ~this)) ~k)]
         (do
           (>! result# in_memo#))
         (let [tmp# (chan )]
           (~original_fn
             tmp#)
           (let [original_result# (<! tmp#)]
             (swap! (:memo (meta ~this)) assoc ~k original_result#)
             (>! result# original_result#)))))
     result#))