(ns com.edocu.help.sentry
  (:require [ring.util.response :as ring-res]
            [com.edocu.users.protocols :as users])
  (:import [org.slf4j MDC]
           [com.getsentry.raven Raven]
           [com.getsentry.raven.event UserBuilder]))

(defmacro put-in-mdc
  ([kvs]
   `(do
      (MDC/clear)
      ~@(map (fn [[k v]] `(put-in-mdc ~k ~v)) kvs)))
  ([key value]
   `(MDC/put (str ~key) (pr-str ~value))))

(defn wrap-sentry-user
  "Returns a Ring middleware handler that add user uid do sentry context"
  [handler]
  (fn [request]
    (let [raven (Raven/getStoredInstance)
          ;context (.getContext raven)
          user-uid (or
                     (ring-res/get-header request)
                     users/OPEN_USER_UID)]
      (println "CONTEXTTTTTTTTT" raven user-uid)
      #_(.setUser
        context
        (.. (UserBuilder.)
            (setUsername user-uid)
            (build)))
      (handler request))))
