(ns com.edocu.help.rest
  (:require [cheshire.core :as json]
            [clojure.core.async :refer [go >!]]))

(defn is-know-content-type? [ctx supported]
  (some (set (map
               clojure.string/trim
               (clojure.string/split
                 (or
                   (get-in ctx [:request :headers "content-type"])
                   (get-in ctx [:request :headers "Content-type"])
                   "")
                 #";")))
        supported))

(defmacro know-content-type? [known]
 `(fn [ctx#]
    (if (#{:patch :post :put} (get-in ctx# [:request :request-method]))
      (is-know-content-type? ctx# ~known)
      true)))

(defn malformed? [ctx checker_fn] 
  #_(timbre/trace "Malformed:" ctx)
  (if (#{:patch :post :put} (get-in ctx [:request :request-method]))
     (try
       (let [body (json/parse-string (slurp (get-in ctx [:request :body])) true)]
         [(checker_fn
            body) 
          {:body body}])
       (catch Exception e
         #_(timbre/error "Malformed input:" (get-in ctx [:request :body]) "error:" e)
         true))
     false))

(defn options 
  ([user]
    (options user {}))
  ([user others?]
    (merge-with merge 
      {:timeout 15000
       :headers {"uid" (:uid user)
                 "Accept" "application/json"}}
      others?)))

(defprotocol RESTLinks
  (links [this] "Return set of links"))

(defn method-to-privilege [ctx]
  ((get-in ctx [:request :request-method]) {:get :read
                                            :head :read
                                            :post :update
                                            :put :update
                                            :patch :update
                                            :delete :update}))
