(ns com.edocu.users.core
  (:use [com.edocu.users.protocols])
  (:require [com.edocu.users.http :as http]
            [com.edocu.help.memo :as memo :refer :all]
            [taoensso.timbre :as timbre]
            [clojure.core.async :refer [go chan <! <!!]])
  (:import [com.edocu.users.protocols 
            Users
            User]))

(def global-impl
  {:lazy->User (fn [global uid]
                 (let [user (map->User {:uid uid})]
                   (init-memo-storage user)))
   
   :create->User (fn [global author uid cn sn mail mobile preferredLanguage password]
                   (go
                     (timbre/trace "create->User" "uid" uid 
                                   "cn" cn 
                                   "sn" sn 
                                   "mail" mail 
                                   "mobile" mobile 
                                   "preferredLanguage" preferredLanguage)
                     (let [user (->User uid cn sn mail mobile preferredLanguage password)]
                       (when (<! (http/create->User author user))
                         (init-memo-storage user)))))})

(def privilege-impl
  {:privileges-in-element (fn
                            ([this edocu_element]
                              (privileges-in-element this edocu_element nil))
                            ([this edocu_element attribute_filter?]
                              (with-memo
                                this
                                [:privileges-in-element
                                 [(:element_hash edocu_element) attribute_filter?]]
                                (partial http/privileges-in-element
                                         this
                                         edocu_element
                                         attribute_filter?))))
   
   :privileges-in-organization (fn 
                                 ([this organization ^String element_type]
                                   (privileges-in-organization this organization element_type nil))
                                 ([this organization ^String element_type attribute_filter?]
                                   (with-memo
                                     this
                                     [:privileges-in-organization 
                                      [(:uid organization) element_type attribute_filter?]]
                                     (partial http/privileges-in-organization
                                              this
                                              organization
                                              element_type
                                              attribute_filter?))))
   
   :organizations (fn [this]
                    (with-memo
                      this
                      :organizations
                      (partial http/organizations
                               this)))})

(extend Users
  Global
  global-impl)

(extend User
  Privilege
  privilege-impl)

