(ns com.edocu.users.protocols)

(defrecord Users [])

(def ->Users (memoize ->Users))

(defrecord User [uid cn sn mail mobile preferredLanguage password])

(defrecord Privileges [type_privileges attribute_privileges password])

(defprotocol Global
  (lazy->User [global uid] "Return lazy instantion of User")
  (create->User [global author_uid uid cn sn mail mobile preferredLanguage password] "Return channel with user object if created"))

(defprotocol Privilege
  (organizations [this] "Return channel with user's organizations")
  (privileges-in-organization 
    [this organization ^String element_type]
    [this organization ^String element_type attribute_filter?] "Return channel with user privilege in organization for element type")
  (privileges-in-element 
    [this edocu_element]
    [this edocu_element attribute_filter?] "Return channel with user privileges in element"))