(ns com.edocu.users.http
  (:require [com.edocu.users.protocols :as users]
            [com.edocu.users.configuration :as config]
            [taoensso.timbre :as timbre]
            [cheshire.core :as json]
            [com.edocu.help.rest :refer [options]]
            [org.httpkit.client :as http :refer [edocu-get edocu-post ERROR_ETAG]]
            [clojure.core.async :refer [go chan <! >!]]))

(defn- construct-user-privileges [respond_body privilege_filter]
  (timbre/trace "construct-user-privileges" "respond_body:" respond_body "privilege_filter:" privilege_filter)
  (users/->Privileges
    (if-let [type_privs (get-in respond_body [:privileges :type])] 
      (set (map keyword type_privs))
      #{})
    (let [att_privs (if-let [tmp (get-in respond_body [:privileges :attributes])]
                      tmp
                      {})]
      (if privilege_filter
        (set (map keyword att_privs))
        (zipmap
          (keys att_privs)
          (map (fn [privs] (set privs)) (vals att_privs)))))))

(defn privileges-in-element [user edocu_element privilege_filter response_channel]
  (let [base_url (format "%s%s" 
                         (config/USER_PRIVILEGES_IN_ELEMENT )
                         (:element_hash edocu_element))]
    (timbre/trace "privileges-in-element" "user:" user "edocu_element" edocu_element "privilege_filter" privilege_filter "base_url:" base_url)
    (edocu-get response_channel
               base_url
               (options user {:query-params (if privilege_filter {:only (name privilege_filter)} {})})
               "Nugeta"
               #(construct-user-privileges % privilege_filter))))

(defn organizations [user response_channel]
  (edocu-get response_channel
             (config/USER_ORGANIZATIONS )
             (options user)
             "Api Old"
             #(:organizations %)))

(defn privileges-in-organization [user organization ^String element_type privilege_filter response_channel]
  (let [base_url (format "%s/%s/%s"
                         (config/USER_PRIVILEGES_IN_ORGANIZATION_FOR_ELEMENT_TYPE )
                         (:uid organization)
                         element_type)]
    (timbre/trace "privilege-in-organization:" "user:" user "organization:" organization "element type:" element_type "base_url:" base_url)
    (edocu-get response_channel
               base_url
               (options user {:query-params (if privilege_filter {:only (name privilege_filter)} {})})
               "Nugeta"
               #(construct-user-privileges % privilege_filter))))

(defn create->User [author user]
  (let [response_channel (chan )] 
    (timbre/trace "create->User" "user:" user)
    (http/post (config/CREATE_USER )
               {:headers {"uid" (:uid author)
                          "Content-Type" config/USER_CREATE_CONTENT_TYPE
                          "Accept" config/USER_CREATE_CONTENT_TYPE}
                :body (json/generate-string user)}
               (fn [{:keys [status body error]}] 
                 (let [log_lvl (if error
                                 #'timbre/error
                                 #'timbre/trace)]
                   (log_lvl "create->User" "user:" user "status:" status "error:" error "body:" body))
                 (go
                   (>! response_channel (= 201 status)))))
    response_channel))

