(ns com.edocu.users.configuration)

(def ENV (promise ))

(defn env []
  (if-not (realized? ENV)
    (deliver ENV :dev))
  @ENV)

(defn USER_PRIVILEGES_IN_ELEMENT []
  (case (env)
    :prod "http://nugeta.service.prod.edocu.local/user-privileges/in-element/"
    "http://nugeta.service.dev.edocu.local/user-privileges/in-element/"))

(defn USER_ORGANIZATIONS []
  (case (env )
    :prod "http://api-old.service.prod.edocu.local/users/organizations"
    "http://api-old.service.dev.edocu.local/users/organizations"))

(defn USER_PRIVILEGES_IN_ORGANIZATION_FOR_ELEMENT_TYPE []
  (case (env )
    :prod "http://nugeta.service.prod.edocu.local/user-privileges"
    "http://nugeta.service.dev.edocu.local/user-privileges"))

(defn CREATE_USER []
  (case (env)
    :prod "http://users.service.prod.edocu.local"
    "http://users.service.dev.edocu.local"))

(def ^:const ^String USER_CREATE_CONTENT_TYPE "application/vnd.edocu.user.v0.0.1+json")

(def ^:const ^Integer RESPONSE_TIME 5000)
