(ns com.edocu.users.configuration
  (:require [environ.core :as e]))

(def ENV (promise ))

(defn env []
  (if-not (realized? ENV)
    (deliver ENV (or 
                   (keyword (e/env :env)) 
                   :dev)))
  @ENV)

(defn ^String USER_PRIVILEGES_IN_ELEMENT []
  (case (env)
    :prod "http://nugeta.service.prod.edocu.local/user-privileges/in-element/"
    "http://nugeta.service.dev.edocu.local/user-privileges/in-element/"))

(defn ^String USER_ORGANIZATIONS []
  (case (env )
    :prod "http://api-old.service.prod.edocu.local/users/organizations"
    "http://api-old.service.dev.edocu.local/users/organizations"))

(defn ^String NUGETA_SERVICE []
  (case (env )
    :prod "http://nugeta.service.prod.edocu.local"
    "http://nugeta.service.dev.edocu.local"))

(defn ^String USER_PRIVILEGES_IN_ORGANIZATION_FOR_ELEMENT_TYPE []
  (format "%s/user-privileges" (NUGETA_SERVICE )))

(defn ^String CREATE_USER []
  (case (env)
    :prod "http://users.service.prod.edocu.local"
    "http://users.service.dev.edocu.local"))

(def ^:const ^String USER_CREATE_CONTENT_TYPE "application/vnd.edocu.user.v0.0.1+json")

(def ^:const ^Integer RESPONSE_TIME 5000)

(defn ^String CHECK_USER_IN_SECURITY_GROUP
  ([^String user_id ^String security_group_id]
    (format "%s/security-groups/%s/users/%s"
            (NUGETA_SERVICE )
            security_group_id
            user_id))
  ([^String user_id ^String organization_id ^String title]
    (format "%s/security-groups/%s/%s/users/%s"
            (NUGETA_SERVICE )
            organization_id
            title
            user_id)))
