(ns com.edocu.users.help.spec
  (:require [clojure.spec :as s]
            [clojure.core.async :as a]
            [clojure.core.async.impl.protocols :as ap]))

(defmacro chan-of [spec & chan-args]
  `(let [ch# (a/chan ~@chan-args)]
     (reify
       ap/ReadPort
       (take! [_ fn1-handler#]
         (ap/take! ch# fn1-handler#))
       ap/WritePort
       (put! [_ val# fn1-handler#]
         (if (s/valid? ~spec val#)
           (ap/put! ch# val# fn1-handler#)
           (do
             (ap/close! ch#)
             (throw (ex-info (str "Spec failed to validate: "
                                  (s/explain-str ~spec val#))
                             {:validation-err (s/explain-data ~spec val#)
                              :val            val#})))))
       ap/Channel
       (close! [_]
         (ap/close! ch#))
       (closed? [_]
         (ap/closed? ch#)))))