(ns com.edocu.users.help.rest
  (:require [com.edocu.users.protocols :as users]))

(defn unknow-user []
  (users/lazy->User (users/->Users) users/OPEN_USER_UID))

(defn construct-user [ctx]
  (if-let [user_uid (or
                      (get-in ctx [:request :headers "uid"])
                      (get-in ctx [:request :headers "UID"])
                      (get-in ctx [:request :headers "Uid"])
                      (get-in ctx [:request :headers "x-credential-username"])
                      (get-in ctx [:request :headers "X-Credential-Username"]))]
    (users/lazy->User (users/->Users) user_uid)
    (unknow-user)))

(defn authorized? [ctx]
  (let [user (construct-user ctx)]
    [true
     {:user user}]))

