/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit.server;

import clojure.lang.IFn;
import clojure.lang.Keyword;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Map;
import org.httpkit.DynamicBytes;
import org.httpkit.HeaderMap;
import org.httpkit.HttpUtils;
import org.httpkit.HttpVersion;
import org.httpkit.server.ClojureRing;
import org.httpkit.server.HttpRequest;
import org.httpkit.server.HttpServer;
import org.httpkit.server.LinkingRunnable;
import org.httpkit.server.WsAtta;
import sun.misc.Unsafe;

public class AsyncChannel {
    static final Unsafe unsafe;
    static final long closedRanOffset;
    static final long closeHandlerOffset;
    static final long receiveHandlerOffset;
    static final long headerSentOffset;
    private final SelectionKey key;
    private final HttpServer server;
    private HttpRequest request;
    volatile int closedRan = 0;
    private volatile int isHeaderSent = 0;
    private volatile IFn receiveHandler = null;
    volatile IFn closeHandler = null;
    LinkingRunnable serialTask;
    private static final byte[] finalChunkBytes;
    private static final byte[] newLineBytes;
    static Keyword K_BY_SERVER;
    static Keyword K_CLIENT_CLOSED;
    static Keyword K_WS_1000;
    static Keyword K_WS_1001;
    static Keyword K_WS_1002;
    static Keyword K_WS_1003;
    static Keyword K_UNKNOWN;

    public AsyncChannel(SelectionKey key, HttpServer server2) {
        this.key = key;
        this.server = server2;
    }

    public void reset(HttpRequest request2) {
        this.request = request2;
        this.serialTask = null;
        unsafe.putOrderedInt(this, closedRanOffset, 0);
        unsafe.putOrderedInt(this, headerSentOffset, 0);
        unsafe.putOrderedObject(this, closeHandlerOffset, null);
        unsafe.putOrderedObject(this, receiveHandlerOffset, null);
    }

    private static ByteBuffer chunkSize(int size) {
        String s = Integer.toHexString(size) + "\r\n";
        return ByteBuffer.wrap(s.getBytes());
    }

    private void firstWrite(Object data, boolean close) throws IOException {
        ByteBuffer[] buffers;
        HeaderMap headers;
        int status = 200;
        Object body = data;
        if (data instanceof Map) {
            Map resp = (Map)data;
            headers = HeaderMap.camelCase((Map)resp.get(ClojureRing.HEADERS));
            status = ClojureRing.getStatus(resp);
            body = resp.get(ClojureRing.BODY);
        } else {
            headers = new HeaderMap();
        }
        if (headers.isEmpty()) {
            headers.put("Content-Type", "text/html; charset=utf-8");
        }
        if (this.request.isKeepAlive && this.request.version == HttpVersion.HTTP_1_0) {
            headers.put("Connection", "Keep-Alive");
        }
        if (close) {
            buffers = HttpUtils.HttpEncode(status, headers, body);
        } else {
            headers.put("Transfer-Encoding", "chunked");
            ByteBuffer[] bb = HttpUtils.HttpEncode(status, headers, body);
            buffers = body == null ? bb : new ByteBuffer[]{bb[0], AsyncChannel.chunkSize(bb[1].remaining()), bb[1], ByteBuffer.wrap(newLineBytes)};
        }
        if (close) {
            this.onClose(0);
        }
        this.server.tryWrite(this.key, !close, buffers);
    }

    private void writeChunk(Object body, boolean close) throws IOException {
        ByteBuffer t;
        if (body instanceof Map) {
            body = ((Map)body).get(ClojureRing.BODY);
        }
        if (body != null && (t = HttpUtils.bodyBuffer(body)).hasRemaining()) {
            ByteBuffer[] buffers = new ByteBuffer[]{AsyncChannel.chunkSize(t.remaining()), t, ByteBuffer.wrap(newLineBytes)};
            this.server.tryWrite(this.key, !close, buffers);
        }
        if (close) {
            this.serverClose(0);
        }
    }

    public void setReceiveHandler(IFn fn) {
        if (!unsafe.compareAndSwapObject(this, receiveHandlerOffset, null, fn)) {
            throw new IllegalStateException("receive handler exist: " + this.receiveHandler);
        }
    }

    public void messageReceived(Object mesg) {
        IFn f = this.receiveHandler;
        if (f != null) {
            f.invoke(mesg);
        }
    }

    public void sendHandshake(Map<String, Object> headers) {
        HeaderMap map = HeaderMap.camelCase(headers);
        this.server.tryWrite(this.key, HttpUtils.HttpEncode(101, map, null));
    }

    public void setCloseHandler(IFn fn) {
        if (!unsafe.compareAndSwapObject(this, closeHandlerOffset, null, fn)) {
            throw new IllegalStateException("close handler exist: " + this.closeHandler);
        }
        if (this.closedRan == 1) {
            fn.invoke((Object)K_UNKNOWN);
        }
    }

    public void onClose(int status) {
        IFn f;
        if (unsafe.compareAndSwapInt(this, closedRanOffset, 0, 1) && (f = this.closeHandler) != null) {
            f.invoke((Object)AsyncChannel.readable(status));
        }
    }

    public boolean serverClose(int status) {
        if (!unsafe.compareAndSwapInt(this, closedRanOffset, 0, 1)) {
            return false;
        }
        if (this.isWebSocket()) {
            this.server.tryWrite(this.key, HttpUtils.WsEncode((byte)8, ByteBuffer.allocate(2).putShort((short)status).array()));
        } else {
            this.server.tryWrite(this.key, false, ByteBuffer.wrap(finalChunkBytes));
        }
        IFn f = this.closeHandler;
        if (f != null) {
            f.invoke((Object)AsyncChannel.readable(0));
        }
        return true;
    }

    public boolean send(Object data, boolean close) throws IOException {
        if (this.closedRan == 1) {
            return false;
        }
        if (this.isWebSocket()) {
            Object tmp;
            if (data instanceof Map && (tmp = ((Map)data).get(ClojureRing.BODY)) != null) {
                data = tmp;
            }
            if (data instanceof String) {
                this.server.tryWrite(this.key, HttpUtils.WsEncode((byte)1, ((String)data).getBytes(HttpUtils.UTF_8)));
            } else if (data instanceof byte[]) {
                this.server.tryWrite(this.key, HttpUtils.WsEncode((byte)2, (byte[])data));
            } else if (data instanceof InputStream) {
                DynamicBytes bytes = HttpUtils.readAll((InputStream)data);
                this.server.tryWrite(this.key, HttpUtils.WsEncode((byte)2, bytes.get(), bytes.length()));
            } else if (data != null) {
                String mesg = "send! called with data: " + data.toString() + "(" + data.getClass() + "), but only string, byte[], InputStream expected";
                throw new IllegalArgumentException(mesg);
            }
            if (close) {
                this.serverClose(1000);
            }
        } else if (this.isHeaderSent == 1) {
            this.writeChunk(data, close);
        } else {
            this.isHeaderSent = 1;
            this.firstWrite(data, close);
        }
        return true;
    }

    public String toString() {
        Socket s = ((SocketChannel)this.key.channel()).socket();
        return s.getLocalSocketAddress() + "<->" + s.getRemoteSocketAddress();
    }

    public boolean isWebSocket() {
        return this.key.attachment() instanceof WsAtta;
    }

    public boolean isClosed() {
        return this.closedRan == 1;
    }

    private static Keyword readable(int status) {
        switch (status) {
            case 0: {
                return K_BY_SERVER;
            }
            case -1: {
                return K_CLIENT_CLOSED;
            }
            case 1000: {
                return K_WS_1000;
            }
            case 1001: {
                return K_WS_1001;
            }
            case 1002: {
                return K_WS_1002;
            }
            case 1003: {
                return K_WS_1003;
            }
        }
        return K_UNKNOWN;
    }

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
            closedRanOffset = unsafe.objectFieldOffset(AsyncChannel.class.getDeclaredField("closedRan"));
            closeHandlerOffset = unsafe.objectFieldOffset(AsyncChannel.class.getDeclaredField("closeHandler"));
            receiveHandlerOffset = unsafe.objectFieldOffset(AsyncChannel.class.getDeclaredField("receiveHandler"));
            headerSentOffset = unsafe.objectFieldOffset(AsyncChannel.class.getDeclaredField("isHeaderSent"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finalChunkBytes = "0\r\n\r\n".getBytes();
        newLineBytes = "\r\n".getBytes();
        K_BY_SERVER = Keyword.intern((String)"server-close");
        K_CLIENT_CLOSED = Keyword.intern((String)"client-close");
        K_WS_1000 = Keyword.intern((String)"normal");
        K_WS_1001 = Keyword.intern((String)"going-away");
        K_WS_1002 = Keyword.intern((String)"protocol-error");
        K_WS_1003 = Keyword.intern((String)"unsupported");
        K_UNKNOWN = Keyword.intern((String)"unknown");
    }
}

