/*
 * Decompiled with CFR 0.152.
 */
package org.httpkit;

import clojure.lang.ISeq;
import clojure.lang.Seqable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.httpkit.DateFormatter;
import org.httpkit.DynamicBytes;
import org.httpkit.HeaderMap;
import org.httpkit.HttpStatus;
import org.httpkit.ProtocolException;

public class HttpUtils {
    public static final Charset ASCII = Charset.forName("US-ASCII");
    public static final Charset UTF_8 = Charset.forName("utf8");
    public static final String CHARSET = "charset=";
    public static final byte COLON = 58;
    public static final byte CR = 13;
    public static final byte LF = 10;
    public static final String TRANSFER_ENCODING = "transfer-encoding";
    public static final String CONTENT_ENCODING = "content-encoding";
    public static final String CONTENT_TYPE = "content-type";
    public static final String CHUNKED = "chunked";
    public static final String CONNECTION = "connection";
    public static final String X_FORWARDED_FOR = "x-forwarded-for";
    public static final String CONTENT_LENGTH = "content-length";
    public static final byte SP = 32;
    private static final byte[] ALPHAS = "0123456789ABCDEF".getBytes();
    static final Pattern ENCODING = Pattern.compile("encoding=('|\")([\\w|-]+)('|\")", 2);
    public static final String CL = "Content-Length";

    public static ByteBuffer bodyBuffer(Object body) throws IOException {
        if (body == null) {
            return null;
        }
        if (body instanceof String) {
            byte[] b = ((String)body).getBytes(UTF_8);
            return ByteBuffer.wrap(b);
        }
        if (body instanceof InputStream) {
            DynamicBytes b = HttpUtils.readAll((InputStream)body);
            return ByteBuffer.wrap(b.get(), 0, b.length());
        }
        if (body instanceof File) {
            return HttpUtils.readAll((File)body);
        }
        if (body instanceof Seqable) {
            ISeq seq;
            DynamicBytes b = new DynamicBytes(seq.count() * 512);
            for (seq = ((Seqable)body).seq(); seq != null; seq = seq.next()) {
                b.append(seq.first().toString(), UTF_8);
            }
            return ByteBuffer.wrap(b.get(), 0, b.length());
        }
        if (body instanceof ByteBuffer) {
            return (ByteBuffer)body;
        }
        throw new RuntimeException(body.getClass() + " is not understandable");
    }

    public static String encodeURI(String url) {
        byte[] bytes = url.getBytes(UTF_8);
        DynamicBytes buffer2 = new DynamicBytes(bytes.length * 2);
        boolean e = true;
        for (byte b : bytes) {
            byte c;
            byte by = c = b < 0 ? b + 256 : b;
            if (c < 33 || c > 126) {
                e = true;
            } else {
                switch (c) {
                    case 34: 
                    case 60: 
                    case 62: 
                    case 92: 
                    case 94: 
                    case 96: 
                    case 123: 
                    case 124: 
                    case 125: {
                        e = true;
                        break;
                    }
                    default: {
                        e = false;
                    }
                }
            }
            if (e) {
                buffer2.append((byte)37);
                buffer2.append(ALPHAS[c / 16]);
                buffer2.append(ALPHAS[c % 16]);
                continue;
            }
            buffer2.append(b);
        }
        return new String(buffer2.get(), 0, buffer2.length(), UTF_8);
    }

    public static int findEndOfString(String sb, int offset) {
        int result;
        for (result = sb.length(); result > offset && Character.isWhitespace(sb.charAt(result - 1)); --result) {
        }
        return result;
    }

    public static int findNonWhitespace(String sb, int offset) {
        int result;
        for (result = offset; result < sb.length() && Character.isWhitespace(sb.charAt(result)); ++result) {
        }
        return result;
    }

    public static int findWhitespace(String sb, int offset) {
        int result;
        for (result = offset; result < sb.length() && !Character.isWhitespace(sb.charAt(result)); ++result) {
        }
        return result;
    }

    public static int getChunkSize(String hex) throws ProtocolException {
        hex = hex.trim();
        for (int i = 0; i < hex.length(); ++i) {
            char c = hex.charAt(i);
            if (c != ';' && !Character.isWhitespace(c) && !Character.isISOControl(c)) continue;
            hex = hex.substring(0, i);
            break;
        }
        try {
            return Integer.parseInt(hex, 16);
        }
        catch (Exception e) {
            throw new ProtocolException("Expect chunk size to be a number, get" + hex);
        }
    }

    public static String camelCase(String key) {
        StringBuilder sb = new StringBuilder(key.length());
        boolean upper = true;
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (upper) {
                sb.append(Character.toUpperCase(c));
            } else {
                sb.append(Character.toLowerCase(c));
            }
            upper = c == '-';
        }
        return sb.toString();
    }

    public static String getPath(URI uri) {
        String path2 = HttpUtils.encodeURI(uri.getRawPath());
        String query = uri.getRawQuery();
        if ("".equals(path2)) {
            path2 = "/";
        }
        if (query == null) {
            return path2;
        }
        return path2 + "?" + query;
    }

    public static int getPort(URI uri) {
        int port = uri.getPort();
        if (port == -1) {
            port = "https".equals(uri.getScheme()) ? 443 : 80;
        }
        return port;
    }

    public static String getHost(URI uri) {
        String host = uri.getHost();
        int port = uri.getPort();
        if (port != -1) {
            host = host + ":" + port;
        }
        return host;
    }

    public static InetSocketAddress getServerAddr(URI uri) throws UnknownHostException {
        InetAddress host = InetAddress.getByName(uri.getHost());
        return new InetSocketAddress(host, HttpUtils.getPort(uri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readContent(File f, int length) throws IOException {
        byte[] bytes = new byte[length];
        FileInputStream fs = null;
        try {
            fs = new FileInputStream(f);
            for (int offset = 0; offset < length; offset += fs.read(bytes, offset, length - offset)) {
            }
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Exception exception) {}
            }
        }
        return bytes;
    }

    public static ByteBuffer readAll(File f) throws IOException {
        int length = (int)f.length();
        if (length >= 0x1400000) {
            FileInputStream fs = new FileInputStream(f);
            MappedByteBuffer buffer2 = fs.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, length);
            fs.close();
            return buffer2;
        }
        return ByteBuffer.wrap(HttpUtils.readContent(f, length));
    }

    public static DynamicBytes readAll(InputStream is) throws IOException {
        int read;
        DynamicBytes bytes = new DynamicBytes(32768);
        byte[] buffer2 = new byte[16384];
        while ((read = is.read(buffer2)) != -1) {
            bytes.append(buffer2, read);
        }
        is.close();
        return bytes;
    }

    public static String getStringValue(Map<String, Object> headers, String key) {
        Object o = headers.get(key);
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    public static void printError(String msg, Throwable t) {
        String error2 = String.format("%s [%s] ERROR - %s", new Date(), Thread.currentThread().getName(), msg);
        StringWriter str = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)str, false);
        pw.println(error2);
        t.printStackTrace(pw);
        System.err.print(str.getBuffer().toString());
    }

    public static void splitAndAddHeader(String sb, Map<String, Object> headers) {
        int colonEnd;
        int nameStart;
        char ch;
        int nameEnd;
        int length = sb.length();
        for (nameEnd = nameStart = HttpUtils.findNonWhitespace(sb, 0); nameEnd < length && (ch = sb.charAt(nameEnd)) != ':' && !Character.isWhitespace(ch); ++nameEnd) {
        }
        for (colonEnd = nameEnd; colonEnd < length; ++colonEnd) {
            if (sb.charAt(colonEnd) != ':') continue;
            ++colonEnd;
            break;
        }
        int valueStart = HttpUtils.findNonWhitespace(sb, colonEnd);
        int valueEnd = HttpUtils.findEndOfString(sb, valueStart);
        String key = sb.substring(nameStart, nameEnd);
        if (valueStart <= valueEnd) {
            String value = sb.substring(valueStart, valueEnd);
            Object v = headers.get(key = key.toLowerCase());
            if (v != null) {
                value = v.toString() + "," + value;
            }
            headers.put(key, value);
        }
    }

    public static Charset parseCharset(String type) {
        if (type != null) {
            try {
                type = type.toLowerCase();
                int i = type.indexOf(CHARSET);
                if (i != -1) {
                    String charset = type.substring(i + CHARSET.length()).trim();
                    return Charset.forName(charset);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static Charset guess(String html, String patten) {
        int start;
        int end;
        int idx = html.indexOf(patten);
        if (idx != -1 && (end = html.indexOf(34, start = idx + patten.length())) != -1) {
            try {
                return Charset.forName(html.substring(start, end));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Charset detectCharset(Map<String, Object> headers, DynamicBytes body) {
        Matcher matcher;
        String s;
        Charset result = HttpUtils.parseCharset(HttpUtils.getStringValue(headers, CONTENT_TYPE));
        if (result == null && (result = HttpUtils.guess(s = new String(body.get(), 0, Math.min(512, body.length()), ASCII), CHARSET)) == null && (matcher = ENCODING.matcher(s)).find()) {
            try {
                result = Charset.forName(matcher.group(2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result == null ? UTF_8 : result;
    }

    public static ByteBuffer[] HttpEncode(int status, HeaderMap headers, Object body) {
        ByteBuffer bodyBuffer;
        try {
            bodyBuffer = HttpUtils.bodyBuffer(body);
            if (!CHUNKED.equals(headers.get("Transfer-Encoding"))) {
                if (bodyBuffer != null) {
                    headers.putOrReplace(CL, Integer.toString(bodyBuffer.remaining()));
                } else {
                    headers.putOrReplace(CL, "0");
                }
            }
        }
        catch (IOException e) {
            byte[] b = e.getMessage().getBytes(ASCII);
            status = 500;
            headers.clear();
            headers.put(CL, Integer.toString(b.length));
            bodyBuffer = ByteBuffer.wrap(b);
        }
        headers.put("Server", "http-kit");
        headers.put("Date", DateFormatter.getDate());
        DynamicBytes bytes = new DynamicBytes(196);
        byte[] bs = HttpStatus.valueOf(status).getInitialLineBytes();
        bytes.append(bs, bs.length);
        headers.encodeHeaders(bytes);
        ByteBuffer headBuffer = ByteBuffer.wrap(bytes.get(), 0, bytes.length());
        if (bodyBuffer != null) {
            return new ByteBuffer[]{headBuffer, bodyBuffer};
        }
        return new ByteBuffer[]{headBuffer};
    }

    public static ByteBuffer WsEncode(byte opcode, byte[] data, int length) {
        byte b0 = 0;
        b0 = (byte)(b0 | 0x80);
        b0 = (byte)(b0 | opcode);
        ByteBuffer buffer2 = ByteBuffer.allocate(length + 10);
        buffer2.put(b0);
        if (length <= 125) {
            buffer2.put((byte)length);
        } else if (length <= 65535) {
            buffer2.put((byte)126);
            buffer2.putShort((short)length);
        } else {
            buffer2.put((byte)127);
            buffer2.putLong(length);
        }
        buffer2.put(data, 0, length);
        buffer2.flip();
        return buffer2;
    }

    public static ByteBuffer WsEncode(byte opcode, byte[] data) {
        return HttpUtils.WsEncode(opcode, data, data.length);
    }
}

