(ns com.edocu.nginx-clojure.ring-logger)

(defn wrap-nginx-request [handler]
  (fn [request]
    (let [headers (merge {} (:headers request))
          modified_request (-> {}
                           (merge request)
                           (assoc :headers (zipmap 
                                             (map clojure.string/lower-case (keys headers))
                                             (vals headers)))
                           (assoc :nginx-request request))] 
      (handler modified_request))))

