(ns com.edocu.help.handlers.protocols
  (:require [clojure.tools.logging :as log]
            [io.pedestal.interceptor.helpers :as interceptors]
            [clojure.core.async :as async :refer [put! close!]]))

(defprotocol Routes
  (routes [this] "Return routes"))

(defn nginx-pedestal-handler
  "Return Pedestal Interceptor which send response to nginx downstream"
  []
  (interceptors/after
    ::nginx-pedestal-handler
    (fn [{:keys [response response-channel] :as context}]
      (log/trace "nginx-pedestal-handler.")
      (put! response-channel response (fn [_] (close! response-channel)))
      context)))
