(ns
 pandect.algo.adler32
 "ADLER-32 algorithm implementation"
 (:require
  [pandect.buffer :refer [*buffer-size*]]
  [pandect.utils.convert]))
(do
 (do
  (clojure.core/defprotocol G__1215 (compute-adler321213 [data1214]))
  (clojure.core/doseq
   [v__198__auto__ [#'G__1215 #'compute-adler321213]]
   (clojure.core/alter-meta!
    v__198__auto__
    clojure.core/assoc
    :private
    true))
  (clojure.core/extend-protocol
   G__1215
   (clojure.core/class (clojure.core/byte-array 0))
   (compute-adler321213
    [data1214]
    (clojure.core/let
     [buf__916__auto__
      (clojure.core/bytes data1214)
      a__917__auto__
      (new java.util.zip.Adler32)]
     (.update
      a__917__auto__
      buf__916__auto__
      0
      (clojure.core/alength buf__916__auto__))
     (.getValue a__917__auto__)))
   java.lang.String
   (compute-adler321213
    [data1214]
    (clojure.core/let
     [data1214 (.getBytes data1214 "UTF-8")]
     (clojure.core/let
      [buf__916__auto__
       (clojure.core/bytes data1214)
       a__917__auto__
       (new java.util.zip.Adler32)]
      (.update
       a__917__auto__
       buf__916__auto__
       0
       (clojure.core/alength buf__916__auto__))
      (.getValue a__917__auto__)))))
  (clojure.core/extend-protocol
   G__1215
   java.io.InputStream
   (compute-adler321213
    [data1214]
    (clojure.core/let
     [s__918__auto__
      data1214
      c__919__auto__
      (clojure.core/int *buffer-size*)
      buf__920__auto__
      (clojure.core/byte-array c__919__auto__)
      a__921__auto__
      (new java.util.zip.Adler32)]
     (clojure.core/loop
      []
      (clojure.core/let
       [r__922__auto__
        (.read s__918__auto__ buf__920__auto__ 0 c__919__auto__)]
       (clojure.core/when-not
        (clojure.core/= r__922__auto__ -1)
        (.update a__921__auto__ buf__920__auto__ 0 r__922__auto__)
        (recur))))
     (.getValue a__921__auto__)))
   java.io.File
   (compute-adler321213
    [data1214]
    (clojure.core/with-open
     [data1214 (clojure.java.io/input-stream data1214)]
     (clojure.core/let
      [s__918__auto__
       data1214
       c__919__auto__
       (clojure.core/int *buffer-size*)
       buf__920__auto__
       (clojure.core/byte-array c__919__auto__)
       a__921__auto__
       (new java.util.zip.Adler32)]
      (clojure.core/loop
       []
       (clojure.core/let
        [r__922__auto__
         (.read s__918__auto__ buf__920__auto__ 0 c__919__auto__)]
        (clojure.core/when-not
         (clojure.core/= r__922__auto__ -1)
         (.update a__921__auto__ buf__920__auto__ 0 r__922__auto__)
         (recur))))
      (.getValue a__921__auto__)))))
  'G__1215)
 (do
  (clojure.core/defn
   adler32*
   "[Hash] ADLER-32 (raw value)"
   [x]
   (compute-adler321213 x))
  (clojure.core/defn
   adler32-file*
   "[Hash] ADLER-32 (raw value)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (compute-adler321213 x)))
  (clojure.core/defn
   adler32-bytes
   "[Hash] ADLER-32 (value -> byte array)"
   [x]
   (pandect.utils.convert/long->4-bytes (compute-adler321213 x)))
  (clojure.core/defn
   adler32-file-bytes
   "[Hash] ADLER-32 (file path -> byte array)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/long->4-bytes (compute-adler321213 x))))
  (clojure.core/defn
   adler32
   "[Hash] ADLER-32 (value -> string)"
   [x]
   (pandect.utils.convert/long->hex (compute-adler321213 x)))
  (clojure.core/defn
   adler32-file
   "[Hash] ADLER-32 (file path -> string)"
   [x]
   (clojure.core/with-open
    [x (clojure.java.io/input-stream (clojure.java.io/file x))]
    (pandect.utils.convert/long->hex (compute-adler321213 x))))))
